let qtObject = null;
let flag = true;
new QWebChannel(qt.webChannelTransport, function (channel) {
    // console.log('channel', channel);
    qtObject = channel.objects.channelqtObject;
    qtObject.sigDidReceiveCoordinate.connect((xx, yy) => {
        // console.log("sigDidReceiveCoordinate:", xx, yy);
        $('#X').value = Math.round(xx);
        $('#Y').value = Math.round(yy);
        flag = true
    })
})
let uuid = '', action = '', context = '', settings = {};
/* 初始化 */
$SD.on('connected', e => {
    uuid = e.uuid;
    action = e.actionInfo.action;
    context = e.actionInfo.context;
    localAll()
    localStorage.clear()
})

function traverse(obj, parentKey = "") {
    let results = [];
    console.log(obj);
    Object.values(obj).forEach(item => {
        for (const [key, value] of Object.entries(item)) {
            value.forEach((item) => {
                const unitValue = String(Number(item.value)) + String(item.units);
                results.push({ key: key, unitValue: unitValue });
            })
        }
})

// for (const key in obj) {
//     if (obj.hasOwnProperty(key)) {
//         const value = obj[key];
//         // console.log("key: " + key);
//         // console.log("value: " + value);

//         // 如果值是对象（且不是数组）并且包含 "value" 和 "units"
//         if (value && typeof value === 'object' && !Array.isArray(value)) {
//             if (value.hasOwnProperty('value') && value.hasOwnProperty('units')) {
//                 const unitValue = String(Number(value.value)) + String(value.units);
//                 results.push({ key: key, unitValue: unitValue });
//             }
//             // 递归遍历子对象，并合并返回结果
//             results = results.concat(traverse(value, key));
//         }
//         // 如果值是数组，递归遍历每个元素
//         else if (Array.isArray(value)) {
//             value.forEach(item => {
//                 if (item && typeof item === 'object') {
//                     results = results.concat({ key: key, unitValue: unitValue });
//                     // results = results.concat(traverse(item, key));
//                 }
//             });
//         }
//     }
// }

return results;
}

if (!Element.prototype.replaceChildren) {
    Element.prototype.replaceChildren = function (...nodes) {
        while (this.firstChild) {
            this.removeChild(this.firstChild);
        }
        this.append(...nodes);
    };
}

/* 刷新显示 */
$SD.on('sendToPropertyInspector', e => {
    // console.log(e);
    if (e.event === 'didReceiveSettings') {
        settings = e.payload.settings
        // console.log(settings);

        if (settings.titleParameters) {
            $('#fontSize').value = settings.titleParameters.fontSize
            // $('#underline').value = settings.titleParameters.underline
            // $('#underline').style.backgroundColor = settings.titleParameters.underline ? '#555555' : '#3d3d3d'
            $('#opacity').value = settings.titleParameters.opacity * 100
            $('#selectFontColor').value = settings.titleParameters.color
            $('#fontColor').style.backgroundColor = settings.titleParameters.color
            // $('#blod').value = settings.titleParameters.blod
            // $('#blod').style.backgroundColor = settings.titleParameters.blod ? '#555555' : '#3d3d3d'
            // $('#italic').value = settings.titleParameters.italic
            // $('#italic').style.backgroundColor = settings.titleParameters.italic ? '#555555' : '#3d3d3d'
            $('#text').value = settings.titleParameters.text
            $('#showTitle').checked = settings.titleParameters.showTitle
            $('#hideTitle').checked = !settings.titleParameters.showTitle
        }


        $('#X').value = Math.round(settings.x)
        $('#Y').value = Math.round(settings.y)

        // 设置fonts
        // console.log(settings);

        if (settings.titleParameters.FontList) {
            const fonts = settings.titleParameters.FontList;

            // 建议在 append 之前先把下拉框清空
            const listEl = document.getElementById('fontFamily');
            // listEl.innerHTML = ''


            if (window.choicesInstance) {
                window.choicesInstance.destroy();
            }
            // 创建 Choices 实例
            window.choicesInstance = new Choices(listEl, {
                searchEnabled: true,   // 开启搜索
                itemSelectText: '',    // 去掉选中时的辅助文字
                shouldSort: false      // 保持原始顺序
            });
            window.choicesInstance.input?.element.addEventListener('focus', () => {
                document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                document.querySelector('.sdpi-wrapper').style.overflowY = "hidden";
                window.choicesInstance.containerOuter.element.scrollIntoView({
                    behavior: 'smooth', // 平滑滚动，可选
                    block: 'start'      // 滚动到顶部（start | center | end | nearest）
                });
            });
            window.choicesInstance.input?.element.addEventListener('blur', () => {
                document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                document.querySelector('.sdpi-wrapper').style.overflowY = "scroll";
            });
            // 添加选项
            window.choicesInstance.setChoices(
                fonts.map(font => ({
                    value: font.value,
                    label: font.name,
                    selected: font.value === (settings.titleParameters.fontFamily || fonts[0].value)
                })),
                'value',
                'label',
                true // resetChoices: true
            );
        }
        updateOpacityProgressBar();//更新透明度进度条显示

        if (action === 'com.hotspot.stream.system.cpu.temperature' || action === 'com.hotspot.stream.system.Gpu_Temperature'||action === 'com.hotspot.stream.system.PhysicalDisk.Temperature') {
            $('#degreesCelsius').checked = ($('#degreesCelsius').value === settings.titleParameters.temperatureType)
            $('#degreeFahrenheit').checked = ($('#degreeFahrenheit').value === settings.titleParameters.temperatureType)
        }

        if (action === 'com.hotspot.stream.system.NetWork') {
            $('#oneLine').checked = ($('#oneLine').value === settings.titleParameters.titleLines)
            $('#twoLines').checked = ($('#twoLines').value === settings.titleParameters.titleLines)
        }

        if (action === 'com.hotspot.stream.system.volume') {
            // 建议在 append 之前先把下拉框清空
            const listEl = document.getElementById('select');
            // listEl.innerHTML = ''


            if (window.choicesVolume) {
                window.choicesVolume.destroy();
            }
            // 创建 Choices 实例
            window.choicesVolume = new Choices(listEl, {
                searchEnabled: true,   // 开启搜索
                itemSelectText: '',    // 去掉选中时的辅助文字
                shouldSort: false      // 保持原始顺序
            });
            window.choicesVolume.input?.element.addEventListener('focus', () => {
                // 输入框获取焦点后设置超出隐藏（干掉最外层滚动）
                document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                document.querySelector('.sdpi-wrapper').style.overflowY = "hidden";
                window.choicesVolume.containerOuter.element.scrollIntoView({
                    behavior: 'smooth', // 平滑滚动，可选
                    block: 'start'      // 滚动到顶部
                });
            });
            window.choicesVolume.input?.element.addEventListener('blur', () => {
                // 输入框失去焦点后恢复滚动
                document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                document.querySelector('.sdpi-wrapper').style.overflowY = "scroll";
            });

            // 添加选项
            window.choicesVolume.setChoices(
                (settings.titleParameters.devices || []).map((item, index) => ({
                    value: index,
                    label: item,
                    selected: settings.select == (index || 0)
                })),
                'value',
                'label',
                true // resetChoices: true
            );

            // $('#select').innerHTML = (settings.titleParameters.devices || []).map((item, index) => {
            //     return `<option value="${index}" ${settings.select == index ? "selected" : ""}>${item}</option>`;
            // }).join('');
        }

        if (action === 'com.hotspot.stream.system.PhysicalDisk') {
            let DriveNames = settings.DriveNames
            let VolumeNames = settings.VolumeNames
            let html = ''
            DriveNames.forEach((item, i) => {
                html += `<option value="${i}">${item} (${VolumeNames[i]})</option>`
            });
            $('#volumeNameItem').innerHTML = html

            $('#diskMode').value = settings.titleParameters.diskMode
            $('#volumeNameItem').value = settings.titleParameters.volumeNameItem
            $('#switchFrequency').value = settings.titleParameters.switchFrequency
            $('#switchFrequencyValue').innerHTML = $('#switchFrequency').value
            $('#showVolumeName').checked = settings.titleParameters.showVolumeName === true ? true : false
            $('#hideVolumeName').checked = settings.titleParameters.showVolumeName === true ? false : true;

            if ($('#diskMode').value === 'Single_Disk')  //单个磁盘
            {
                $('#selectVolumeName').style.display = 'block';
                $('#selectSwitchFrequency').style.display = 'none';
                $('#showSwitchFrequency').style.display = 'none';
            }
            else if ($('#diskMode').value === 'Disk_Loop')  //磁盘循环
            {
                $('#selectVolumeName').style.display = 'none';
                $('#selectSwitchFrequency').style.display = 'block';
                $('#showSwitchFrequency').style.display = 'block';
                updateSwitchFrequencyProgressBar();//更新切换频率进度条的显示
            }
            else if ($('#diskMode').value === 'Total_Disks')  //全部磁盘
            {
                $('#selectVolumeName').style.display = 'none';
                $('#selectSwitchFrequency').style.display = 'none';
                $('#showSwitchFrequency').style.display = 'none';
            }
        }

        if (action === 'com.hotspot.stream.AllDATA')//自定义数据
        {
            /* ① 用户是否正在搜索？ */
            // const keyword = $('#dataSearch').value.trim();
            // if (keyword) return; // 有值 ⇒ 跳过列表更新

            const foundData = traverse(settings.titleParameters.AllData);

            if (foundData.length > 0) {

                const listEl = document.getElementById('AllDataList');
                // listEl.innerHTML = ''


                if (window.choicesAllDATA) {
                    window.choicesAllDATA.destroy();
                }
                // 创建 Choices 实例
                window.choicesAllDATA = new Choices(listEl, {
                    searchEnabled: true,   // 开启搜索
                    itemSelectText: '',    // 去掉选中时的辅助文字
                    shouldSort: false      // 保持原始顺序
                });
                // console.log(window.choicesAllDATA);

                window.choicesAllDATA.input?.element.addEventListener('focus', () => {
                    document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                    document.querySelector('.sdpi-wrapper').style.overflowY = "hidden";
                    window.choicesAllDATA.containerOuter.element.scrollIntoView({
                        behavior: 'smooth', // 平滑滚动，可选
                        block: 'start'      // 滚动到顶部（start | center | end | nearest）
                    });
                });
                window.choicesAllDATA.input?.element.addEventListener('blur', () => {
                    document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                    document.querySelector('.sdpi-wrapper').style.overflowY = "scroll";
                });
                // 添加选项
                window.choicesAllDATA.setChoices(
                    foundData.map((item) => ({
                        value: item.key,
                        label: item.key,
                        selected: item.key == (settings.titleParameters.SelectValue || foundData[0].key)
                    })),
                    'value',
                    'label',
                    true // resetChoices: true
                );

                // // 建议在 append 之前先把下拉框清空
                // const listEl = $('#AllDataList');
                // listEl.innerHTML = ''

                // // 为数组中的每个元素创建一个option元素
                // foundData.map(item => {
                //     let option = document.createElement("option");
                //     option.value = item.key;
                //     option.text = item.key;
                //     $('#AllDataList').appendChild(option);
                // });
                // $('#AllDataList').value = settings.titleParameters.SelectValue ? settings.titleParameters.SelectValue : item[0].key;
            }
        }

        if (action == 'com.hotspot.stream.system.PhysicalDisk.Temperature') {
            /* ── 1. 拿到磁盘对象并提取“盘名” ─────────────────────────── */
            const diskObj = settings.titleParameters.PhysicalDiskTemperatureList;
            console.log(diskObj);
            console.log(settings.titleParameters);


            const diskNames = Object.keys(diskObj);            // ["S.M.A.R.T.: PM991a NVMe …", ...]

            const foundData = traverse(settings.titleParameters.PhysicalDiskTemperatureList);
            console.log(foundData);

            /* ── 2. 确保页面里有 <select id="diskSelect"> ─────────────── */
            let diskSelect = document.getElementById('diskSelect');
            // if (!diskSelect) {
            //     // 如果 HTML 里没写，运行期动态插一个下拉框（放在字体样式上方）
            //     const label = document.createElement('label');
            //     label.className = 'w-20 text-right right-4';
            //     label.textContent = '硬盘:';

            //     diskSelect = document.createElement('select');
            //     diskSelect.id        = 'diskSelect';
            //     diskSelect.className = 'w-full p-3 border-none outline-none bg-3d3d3d text-white';

            //     const wrapper = document.createElement('div');
            //     wrapper.className = 'flex items-center my-4';
            //     wrapper.appendChild(label);

            //     const inner = document.createElement('div');
            //     inner.className = 'flex-1';
            //     inner.appendChild(diskSelect);
            //     wrapper.appendChild(inner);

            //     // 把 wrapper 插到“字体样式”那一段之前
            //     const fontStyleRow = document.getElementById('fontFamily')?.parentElement?.parentElement;
            //     fontStyleRow?.parentElement?.insertBefore(wrapper, fontStyleRow);
            // }

            /* ── 3. 填充下拉框 ──────────────────────────────────────────── */
            diskSelect.innerHTML = '';                            // 清空旧选项
            diskNames.forEach(name => {
                const opt = document.createElement('option');
                opt.value = name;          // 可按需改成磁盘 ID
                opt.textContent = name;
                diskSelect.appendChild(opt);
            });

            // 若希望默认选中第一块盘
            //if (diskNames.length) diskSelect.selectedIndex = 0;

            /* ── 4. 选择变化时写回 settings 并触发你的逻辑 ──────────── */
            // diskSelect.onchange = () => {
            //     //settings.selectedDisk = diskSelect.value;           // 记录当前选中
            //     updateDisk();                                     // 你的自定义保存 / 上报函数
            // };

            if (diskNames.length) {
                $('#diskSelect').value = settings.titleParameters.SelectPhysicalDisk ? settings.titleParameters.SelectPhysicalDisk : 0;
                console.log("settings.titleParameters.SelectPhysicalDisk: " + settings.titleParameters.SelectPhysicalDisk);
            }
        }

        if (action == 'com.hotspot.stream.CPUFan')
        {
            const cpuFanobj = settings.titleParameters.CPUFanList;
            const cpuFanNames = Object.keys(cpuFanobj);
            let cpuFanSelect = document.getElementById('CPUFanSelect');
            cpuFanSelect.innerHTML = '';                            // 清空旧选项
            cpuFanNames.forEach(name => {
                const opt = document.createElement('option');
                opt.value = name;
                opt.textContent = name;
                cpuFanSelect.appendChild(opt);
            });
            if (cpuFanNames.length) {
                $('#CPUFanSelect').value = settings.titleParameters.SelectCPUFan ? settings.titleParameters.SelectCPUFan : 0;
                console.log("settings.titleParameters.SelectCPUFan: " + settings.titleParameters.SelectCPUFan);
            }
        }
    }
})

const increase = () => {
    $('#fontSize').value > 600 ? $('#fontSize').value = 600 : $('#fontSize').value++
    settings.titleParameters.fontSize = $('#fontSize').value * 1
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const decrease = () => {
    $('#fontSize').value <= 1 ? $('#fontSize').value = 1 : $('#fontSize').value--
    settings.titleParameters.fontSize = $('#fontSize').value * 1
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateFontSize = () => {
    $('#fontSize').value < 1 ? $('#fontSize').value = 1 : $('#fontSize').value
    $('#fontSize').value > 600 ? $('#fontSize').value = 600 : $('#fontSize').value
    settings.titleParameters.fontSize = $('#fontSize').value * 1
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

// const updateUnderline = () => {
//     settings.titleParameters.underline = !settings.titleParameters.underline
//     $('#underline').style.backgroundColor = settings.titleParameters.underline ? '#555555' : '#3d3d3d'
//     $SD.api.send(uuid, 'setSettings', {
//         payload: settings
//     });
// }

// const updateItalic = () => {
//     settings.titleParameters.italic = !settings.titleParameters.italic
//     $('#italic').style.backgroundColor = settings.titleParameters.italic ? '#555555' : '#3d3d3d'
//     $SD.api.send(uuid, 'setSettings', {
//         payload: settings
//     });
// }

// const updateBold = () => {
//     settings.titleParameters.blod = !settings.titleParameters.blod
//     $('#blod').style.backgroundColor = settings.titleParameters.blod ? '#555555' : '#3d3d3d'
//     $SD.api.send(uuid, 'setSettings', {
//         payload: settings
//     });
// }

const updateFontColor = () => {
    settings.titleParameters.color = $('#selectFontColor').value
    $('#fontColor').style.backgroundColor = $('#selectFontColor').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateOpacity = () => {
    updateOpacityProgressBar();//更新透明度进度条显示
    settings.titleParameters.opacity = $('#opacity').value / 100
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

/** 根据关键字过滤，并自动把焦点放到第一条匹配项 */
function filterOptions() {
    const kw = document.getElementById("dataSearch").value.trim().toLowerCase();
    const sel = document.getElementById("AllDataList");
    const opts = sel.options;

    let firstVisibleIndex = -1;

    /* 1. 逐项显示 / 隐藏，并记录第一个可见项的索引 */
    for (let i = 0; i < opts.length; i++) {
        const match = kw === "" || opts[i].text.toLowerCase().includes(kw);
        opts[i].style.display = match ? "" : "none";
        if (match && firstVisibleIndex === -1) {
            firstVisibleIndex = i;
        }
    }

    /* 2. 自动选中第一项（如存在），否则清空选择 */
    if (firstVisibleIndex !== -1) {
        sel.selectedIndex = firstVisibleIndex;
    } else {
        sel.selectedIndex = -1;
    }

    /* 3. 如果你希望同步触发下拉框 change 逻辑，可手动调用 */
    updateAllDataList();          // 若内部已做 index 检查，可直接调用
}

const updateFontFamily = () => {
    settings.titleParameters.fontFamily = $('#fontFamily').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateAllDataList = () => {
    settings.titleParameters.SelectValue = $('#AllDataList').value
    settings.titleParameters.text = $('#AllDataList').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateDisk = () => {
    settings.titleParameters.SelectPhysicalDisk = $('#diskSelect').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateCPUFan = () => {
    settings.titleParameters.SelectCPUFan = $('#CPUFanSelect').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}


const updateText = () => {
    settings.titleParameters.text = $('#text').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

// const updateShowTitle = () => {
//     settings.titleParameters.showTitle = $('#showTitle').checked
//     $SD.api.send(uuid, 'setSettings', {
//         payload: settings
//     });
// }

const updateShowTitle = () => {
    settings.titleParameters.showTitle = $('#showTitle').checked ? true : false;
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateTemperatureType = () => {
    settings.titleParameters.temperatureType = $('#degreesCelsius').checked ? $('#degreesCelsius').value : $('#degreeFahrenheit').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateTitleLines = () => {
    settings.titleParameters.titleLines = $('#oneLine').checked ? $('#oneLine').value : $('#twoLines').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateDiskMode = () => {
    if ($('#diskMode').value === 'Single_Disk')  //单个磁盘
    {
        $('#selectVolumeName').style.display = 'block';
        $('#selectSwitchFrequency').style.display = 'none';
        $('#showSwitchFrequency').style.display = 'none';
    }
    else if ($('#diskMode').value === 'Disk_Loop')  //磁盘循环
    {
        $('#selectVolumeName').style.display = 'none';
        $('#selectSwitchFrequency').style.display = 'block';
        $('#showSwitchFrequency').style.display = 'block';
    }
    else if ($('#diskMode').value === 'Total_Disks') {
        $('#selectVolumeName').style.display = 'none';
        $('#selectSwitchFrequency').style.display = 'none';
        $('#showSwitchFrequency').style.display = 'none';
    }

    settings.titleParameters.diskMode = $('#diskMode').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateVolumeNameItem = () => {
    settings.titleParameters.volumeNameItem = $('#volumeNameItem').value
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateSwitchFrequency = () => {
    updateSwitchFrequencyProgressBar();//更新切换频率进度条的显示
    $('#switchFrequencyValue').innerHTML = $('#switchFrequency').value
    settings.titleParameters.switchFrequency = $('#switchFrequency').value * 1
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateOpacityProgressBar = () => {
    const value = $('#opacity').value / 100 * 100;
    document.querySelector('#opacity').style.setProperty('--progress-width', `${value}%`);
}

const updateSwitchFrequencyProgressBar = () => {
    const value = ($('#switchFrequency').value - 1) / 119 * 100;
    document.querySelector('#switchFrequency').style.setProperty('--progress-width', `${value}%`);
}

const updateShowVolumeName = () => {
    settings.titleParameters.showVolumeName = $('#showVolumeName').checked ? true : false;
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const updateVolume = () => {
    settings.select = $('#select').value;
    $SD.api.send(uuid, 'setSettings', {
        payload: settings
    });
}

const onWheel = (e) => {
    e.preventDefault();
    const step = e.deltaY < 0 ? 1 : -1;
    $('#opacity').value = Math.max(0, Math.min(100, parseInt($('#opacity').value) + step));
    updateOpacity();
}

// 坐标轴输入框改变事件

const handleChangeXY = () => {
    const x = $('#X').value;
    const y = $('#Y').value;
    // console.log('qtObject', qtObject)
    qtObject.uDidReceiveCoordinate(x, y)
}
// 监听 方向键按下
const handleKeydown = (event) => {
    // 判断当前焦点是否是输入框
    const activeElement = document.activeElement;
    const isInputFocused = activeElement && (activeElement.tagName === "INPUT" || activeElement.tagName === "TEXTAREA");

    // 如果输入框获取了焦点，直接返回
    if (isInputFocused || !flag) {
        return;
    }
    flag = false;

    let x = parseInt($('#X').value);
    let y = parseInt($('#Y').value);
    switch (event.key) {
        case "ArrowUp":
            y -= 1;
            // console.log('ArrowUp:x-y', x + '-' + y);
            event.preventDefault();
            break;
        case "ArrowDown":
            y += 1;
            // console.log('ArrowDown:x-y', x + '-' + y);
            event.preventDefault();
            break;
        case "ArrowLeft":
            x -= 1;
            // console.log('ArrowLeft:x-y', x + '-' + y);
            event.preventDefault();
            break;
        case "ArrowRight":
            x += 1;
            // console.log('ArrowRight:x-y', x + '-' + y);
            event.preventDefault();
            break;
    }
    qtObject.uDidReceiveCoordinate(x, y);
}
window.addEventListener("keydown", handleKeydown);

$('#opacity').addEventListener('mouseenter', () => {
    $('#opacity').addEventListener('wheel', onWheel);
});


$('#opacity').addEventListener('mouseleave', () => {
    $('#opacity').removeEventListener('wheel', onWheel);
});

