const Timer = new Worker('./utils/worker.js');
const TimerSubscribe = { setTimeout: {}, setInterval: {} };
Timer.addEventListener('message', function ({ data }) {
    TimerSubscribe[data.event][data.id]?.();
});

let info = {
    "Cpu Usage": "50%",//cpu使用率
    "Physical Memory Usage": "50%",//物理内存使用率
    "Gpu Core Utility": "50%",//GPU使用率
    "Gpu Memory Utility": "50%",//GPU显存使用率
    "drives": [{ driveName: "C:\\", freeSpaceGB: 16, freeSpacePercent: 8, volumeName: "" },
    { driveName: "D:\\", freeSpaceGB: 27, freeSpacePercent: 18, volumeName: "" }],//硬盘使用率,要特殊处理多个磁盘
    "defaultAudioEndpointVolume": "50",//默认音频设备的音量
    "Cpu Temperature": "50℃",//cpu温度
    "Cpu Clock": "3900MHz",//cpu频率
    "Cpu Power": "25W",//cpu功耗
    "Gpu Temperature": "50℃",//GPU温度
    "Gpu Core Clock": "1300MHz",//GPU核心频率
    "Gpu Power": "25W",//gpu功耗
    "Physical Memory Usage": "50%",//可用内存（获取的是内存使用率用100-已使用=可用）
    "Disk Temperature": "",//硬盘温度
    "AllAudioEndpointVolume": [],//音量
}

class Actions {
    constructor(data) {
        this.data = {};
        this.default = {};
        Object.assign(this, data);
    }
    // 属性检查器显示时
    static currentAction = null;
    static currentContext = null;
    propertyInspectorDidAppear({ action, context }) {
        Actions.currentAction = action;
        Actions.currentContext = context;
        this._propertyInspectorDidAppear?.(data);
    }
    // 初始化数据
    willAppear(data) {
        data.payload.settings.fontFamilys = window.fontFamilys;
        const { context, payload: { settings } } = data;
        this.data[context] = Object.assign({ ...this.default }, settings);
        this._willAppear?.(data);
    }
    // 行动销毁
    willDisappear(data) {
        this._willDisappear?.(data);
        delete this.data[data.context];
    }
}

class Plugins {
    constructor(name) {
        this.name = name;
    }
    // 延时器/清除延时
    clearTimeout(id) { Timer.postMessage({ event: 'clearTimeout', id }); }
    setTimeout(id, callback, delay) {
        this.clearTimeout(id);
        TimerSubscribe.setTimeout[id] = callback;
        Timer.postMessage({
            event: 'setTimeout',
            id, delay
        });
    }
    // 定时器/清除定时器
    clearInterval(id) { Timer.postMessage({ event: 'clearInterval', id }); }
    setInterval(id, callback, delay) {
        this.clearInterval(id);
        TimerSubscribe.setInterval[id] = callback;
        Timer.postMessage({
            event: 'setInterval',
            id, delay
        });
    }
}

// 软件通信
window.connectSocket = window.connectElgatoStreamDeckSocket = function () {
    const uuid = arguments[1], event = arguments[2];
    window.info = JSON.parse(arguments[3]);
    window.socket = new WebSocket("ws://127.0.0.1:" + arguments[0]);

    window.fontFamilys = []
    const fonts = window.info.fonts;

    fonts.map(async (font) => {
        window.fontFamilys.push(font.name);
        // 判断字体是否已存在
        const isFontLoaded = [...document.fonts].some(
            (loadedFont) => loadedFont.family === font.name
        );

        if (isFontLoaded) {
            // console.log(`Font "${font.name}" is already loaded.`);
            return; // 如果字体已存在，则跳过加载
        }

        // 如果字体不存在，加载并添加
        const f = new FontFace(font.name, `url(${encodeURI(font.url)})`);

        try {
            const loadedFont = await f.load();
            document.fonts.add(loadedFont);
            // console.log(`Font "${font.name}" loaded successfully.`);
        } catch (error) {
            console.error(`Failed to load font "${font.name}":`, error);
        }
    })

    // 打开网页
    WebSocket.prototype.openUrl = function (url) {
        this.send(JSON.stringify({
            event: "openUrl",
            payload: { url }
        }));
    };

    // 与当前属性检查器通信
    WebSocket.prototype.sendToPropertyInspector = function (payload) {
        this.send(JSON.stringify({
            payload,
            event: "sendToPropertyInspector",
            action: Actions.currentAction,
            context: Actions.currentContext
        }));
    };

    // 保存持久化数据
    WebSocket.prototype.setSettings = function (context, payload) {
        this.send(JSON.stringify({
            event: "setSettings",
            context, payload
        }));
    };

    // 设置背景
    WebSocket.prototype.setImage = function (context, url) {
        const image = new Image();
        image.src = url;
        image.onload = () => {
            const canvas = document.createElement("canvas");
            canvas.width = image.naturalWidth;
            canvas.height = image.naturalHeight;
            const ctx = canvas.getContext("2d");
            ctx.drawImage(image, 0, 0);
            this.send(JSON.stringify({
                event: "setImage",
                context, payload: {
                    target: 0,
                    image: canvas.toDataURL("image/png")
                }
            }));
        };
    };

    // 设置标题
    WebSocket.prototype.setTitle = function (context, str, row = 0, num = 6) {
        let newStr = '';
        if (row) {
            let nowRow = 1, strArr = str.split('');
            strArr.forEach((item, index) => {
                if (nowRow < row && index >= nowRow * num) {
                    nowRow++;
                    newStr += '\n';
                }
                if (nowRow <= row && index < nowRow * num) {
                    newStr += item;
                }
            });
            if (strArr.length > row * num) {
                newStr = newStr.substring(0, newStr.length - 1);
                newStr += '..';
            }
        }
        this.send(JSON.stringify({
            event: "setTitle",
            context, payload: {
                target: 0,
                title: newStr || str
            }
        }));
    };

    // 设置状态
    WebSocket.prototype.setState = function (context, state) {
        this.send(JSON.stringify({
            event: "setState",
            payload: { state },
            context
        }));
    };

    window.socket.onopen = () => window.socket.send(JSON.stringify({ uuid, event }));
    window.socket.onmessage = e => {
        const data = JSON.parse(e.data);
        plugin[data.action?.split('.').pop()]?.[data.event]?.(data);
        plugin[data.event]?.(data);
    };

    function connect() {
        window.ws = new WebSocket('ws://127.0.0.1:24509');
        const plugin = new Plugins("单纯只是用他封装的定时器没啥用");
        window.ws.onopen = () => {
            console.log("WebSocket 连接成功");

            const originalSend = window.ws.send;
            const eventList = {};
            window.ws.send = function (data) {//重写send实现相同的事件一秒内只发送一次
                const eventName = data;
                // if (eventList[eventName] && new Date() - eventList[eventName] < 1000) {//不足一秒返回
                //     return;
                // }
                eventList[eventName] = new Date();
                // originalSend.call(window.ws, data);
            };

            plugin.setInterval("WebSocketInterval", () => {
                Object.keys(eventList).forEach(eventName => {
                    // console.log(eventName);

                    // 检查是否超过 10 秒，若超过则删除
                    if (new Date() - eventList[eventName] >= 10000) {
                        delete eventList[eventName];
                    } else if(window.ws.readyState === WebSocket.OPEN){
                        originalSend.call(window.ws, eventName);
                    }
                });
            }, 100)
        };

        window.ws.onmessage = e => {
            const data = JSON.parse(e.data);
            // console.log(data);

            info[data.event] = data.info;
        };

        window.ws.onerror = () => {
            window.ws.close(); // 关闭连接以触发 `onclose`
        };

        window.ws.onclose = () => {
            plugin.clearInterval("WebSocketInterval");
            setTimeout(connect, 1000); // 延迟重连
        };
    }

    connect(); // 初始化连接
};

