/// <reference path="./utils/common.js" />
/// <reference path="./utils/axios.js" />

// 操作一
plugin.Type_8 = new Actions({
    default: {
        data: {}
    },
    isSettings: {},
    async _willAppear({ context, payload }) {
        // window.socket.setTitle(context, "Hello world!");
        try {
            this.isSettings[context] = true;
            //获取磁盘信息
            if (window.ws.readyState === WebSocket.OPEN) {
                window.ws?.send("drives");
                window.ws?.send("AllAudioEndpointVolume");
                window.ws?.send("Disk Temperature");
                window.ws?.send(mapping[this.data[context].titleParameters.showItem]);
            }
            this.calculate(context, this.data[context]);
            // // 加载字体文件
            // const settings = payload.settings;
            // const fonts = JSON.parse(settings.fonts)
            // settings.fontFamilys = []
            // await Promise.all(
            //     fonts.map(async (font) => {
            //         settings.fontFamilys.push(font.name);
            //         // 判断字体是否已存在
            //         const isFontLoaded = [...document.fonts].some(
            //             (loadedFont) => loadedFont.family === font.name
            //         );

            //         if (isFontLoaded) {
            //             // console.log(`Font "${font.name}" is already loaded.`);
            //             return; // 如果字体已存在，则跳过加载
            //         }

            //         // 如果字体不存在，加载并添加
            //         const f = new FontFace(font.name, `url(${encodeURI(font.url)})`);

            //         try {
            //             const loadedFont = await f.load();
            //             document.fonts.add(loadedFont);
            //             // console.log(`Font "${font.name}" loaded successfully.`);
            //         } catch (error) {
            //             console.error(`Failed to load font "${font.name}":`, error);
            //         }
            //     })
            // );
            // console.log('font-settings', settings)
            // delete settings.fonts;
            // window.socket.setSettings(context, settings)
        } catch (error) {
            console.log(error);
        }
        plugin.setInterval(context, () => {
            try {
                if (window.ws.readyState === WebSocket.OPEN) {
                    window.ws?.send(mapping[this.data[context].titleParameters.showItem]);
                }
                this.calculate(context, this.data[context]);
                //更新VolumeNames、DriveNames
                this.updateDrives(context)
                //window.socket.setSettings(context, this.data[context])
            } catch (error) {
                console.log(error);
            }
        }, 500)

        setTimeout(() => {
            //更新VolumeNames、DriveNames
            this.updateDrives(context)
            window.socket.setSettings(context, this.data[context])
        }, 3000)
        if (payload.settings.titleParameters.showItem == "Hard Disk" && payload.settings.titleParameters.diskMode != "Single_Disk") {
            this.loop(context);
        } else {
            plugin.clearInterval(context + 1);
        }
    },
    _willDisappear({ context }) {
        plugin.clearInterval(context);
        plugin.clearInterval(context + 1);
    },
    didReceiveSettings({ context, payload }) {
        if (payload.settings.titleParameters.circleWidth > payload.settings.titleParameters.circleRadius) {
            payload.settings.titleParameters.circleWidth = payload.settings.titleParameters.circleRadius;
            this.updateDrives(context);
            window.socket.setSettings(context, payload.settings);
        }
        try {
            window.ws?.send(payload.settings.titleParameters.showItem);
        } catch (error) {
            console.log(error);
        }
        if (payload.settings.titleParameters.showItem == "Hard Disk" && payload.settings.titleParameters.diskMode != "Single_Disk") {
            this.loop(context);
        } else {
            plugin.clearInterval(context + 1);
        }
        this.calculate(context, payload.settings);
    },
    updateDrives(context) {
        this.data[context].DriveNames = []
        this.data[context].VolumeNames = []
        this.data[context].AudioNames = []
        this.data[context].AudioNameszf = [];
        this.data[context].diskList = [];
        info["drives"].forEach(item => {
            this.data[context].DriveNames.push(item.driveName);
            this.data[context].VolumeNames.push(item.volumeName);
        });
        info["AllAudioEndpointVolume"].forEach(item => {
            this.data[context].AudioNames.push(item.AudioNames);
            this.data[context].AudioNameszf.push(item.AudioNameszf);
        });
        let list = Object.keys(info["Disk Temperature"]);
        if (list.length > 0) {
            this.data[context].diskList = Object.keys(info["Disk Temperature"]);
        }
        this.isSettings[context] = false;
    },
    loop(context) {//磁盘循环
        plugin.clearInterval(context + 1);
        plugin.setInterval(context + 1, () => {
            try {
                this.data[context].titleParameters.volumeNameItem++
                if (this.data[context].titleParameters.volumeNameItem >= this.data[context].DriveNames.length) {
                    this.data[context].titleParameters.volumeNameItem = 0;
                }
            } catch (error) {
                console.log(error);
            }
        }, this.data[context].titleParameters.switchFrequency * 1000)
    },
    getProgress(name, context) {
        //获取进度并返回
        let progress = 50;

        try {
            if (name == "Memory Available") {//可用内存（获取的是内存使用率用100-已使用=可用）
                progress = 100 - parseInt(info[mapping[name]]);
                this.data[context].text = progress + "%";
            } else if (name == "System Volume") {
                progress = Math.round(this.data[context].AudioNameszf[this.data[context].titleParameters.select]) || 0;
                this.data[context].text = progress + "%";
            } else if (name == "Hard Disk") {//硬盘使用率,要特殊处理多个磁盘
                info[mapping[name]]
                if (this.data[context].titleParameters.diskMode == "Single_Disk") {//单个磁盘
                    progress = 100 - info[mapping[name]][this.data[context].titleParameters.volumeNameItem]?.freeSpacePercent
                    this.data[context].text = progress + "%";
                } else {//循环
                    progress = 100 - info[mapping[name]][this.data[context].titleParameters.volumeNameItem]?.freeSpacePercent
                    this.data[context].text = progress + "%";
                }
            } else {
                this.data[context].text = info[mapping[name]]
                progress = parseInt(info[mapping[name]]);
                if (mapping[name] == "Cpu Clock") {
                    progress = parseInt(info[mapping[name]]) / (5 * 1024) * 100;
                }
                if (mapping[name] == "Gpu Core Clock") {
                    progress = parseInt(info[mapping[name]]) / (5 * 1024) * 100;
                }
                if (mapping[name] == "Disk Temperature") {
                    // console.log('diskTemperature', info[mapping[name]], this.data[context].titleParameters['diskName']);
                    const diskObj = info[mapping[name]][this.data[context].titleParameters['diskName']];
                    let diskTemperature = diskObj?.['Drive Temperature'].value || diskObj?.['Drive Temperature 2'].value || 30;
                    this.data[context].text = diskTemperature + "°C";
                    progress = parseInt(diskTemperature);
                }
            }
        } catch (error) {
            console.log(error);
        }
        return progress;
    },

    calculate(context, settings) {
        const data = settings.titleParameters;
        if (this.isSettings[context] || settings.softwareSend) {
            const scale = settings.ActionGeometry.width / this.data[context].ActionGeometry.width;
            settings.titleParameters.fontSize = Math.round(data.fontSize * scale);
            settings.titleParameters.circleRadius = Math.round(data.circleRadius * scale);
            settings.titleParameters.circleWidth = Math.round(data.circleWidth * scale);
            settings.softwareSend = false;
            this.updateDrives(context);
            window.socket.setSettings(context, settings);
        }
        this.data[context] = settings;
        this.draw(context, settings.titleParameters.circleRadius * 2, settings.titleParameters.circleRadius * 2);
    },
    draw(context, canvasWidth, canvasHeight) {
        const settings = this.data[context];
        const progress = this.getProgress(settings.titleParameters.showItem, context);
        const canvas = document.createElement('canvas');
        canvas.width = canvasWidth;
        canvas.height = canvasHeight;
        const ctx = canvas.getContext('2d');

        // 参数设置
        let startAngle = settings.titleParameters.startAngle + 90; // 起始角度
        let totalAngle = settings.titleParameters.totalAngle; // 总角度
        let radius = settings.titleParameters.circleRadius; // 圆弧半径
        let lineWidth = settings.titleParameters.circleWidth; // 圆弧宽度
        let backgroundColor = settings.titleParameters.backgroundColor; // 背景颜色
        let foregroundColor = settings.titleParameters.foregroundColor; // 前景颜色
        let showSegments = settings.titleParameters.section; // 是否分段显示
        let segments = 20; // 分段数
        let spacingPercentage = 10; // 分段间距百分比
        let hideBackGround = settings.titleParameters.hideBackGround; // 隐藏背景
        let rightToLeft = settings.titleParameters.rightToLeft; // 进度条方向

        ctx.clearRect(0, 0, canvas.width, canvas.height);

        // 角度转换为弧度
        let startRad = (startAngle * Math.PI) / 180;
        let endRad = ((startAngle + totalAngle) * Math.PI) / 180;

        // 绘制背景圆弧
        {
            if (hideBackGround) {//如果是隐藏背景就设置一个很小的透明度
                ctx.globalAlpha = 0.01
            }
            if (settings.titleParameters.roundCorner) {
                // const x = canvas.width / 2
                // const y = canvas.height / 2
                // const cornerRadius = lineWidth / 2;  // 圆角的半径
                // let endX = x + (radius - lineWidth / 2) * Math.cos(endRad);
                // let endY = y + (radius - lineWidth / 2) * Math.sin(endRad);
                // ctx.beginPath();
                // ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                // ctx.fillStyle = backgroundColor;
                // ctx.fill();
                // endX = x + (radius - lineWidth / 2) * Math.cos(startRad);
                // endY = y + (radius - lineWidth / 2) * Math.sin(startRad);
                // // 绘制圆角（小圆）
                // ctx.beginPath();
                // ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                // ctx.fillStyle = backgroundColor;
                // ctx.fill();
                const x = canvas.width / 2;
                const y = canvas.height / 2;
                const cornerRadius = lineWidth / 2;  // 圆角的半径

                // 缩短弧度，使圆角包含在原弧度范围内
                const adjustedStartRad = startRad + cornerRadius / radius;
                const adjustedEndRad = endRad - cornerRadius / radius;
                ctx.beginPath();
                ctx.arc(canvas.width / 2, canvas.height / 2, radius - lineWidth / 2, adjustedStartRad, adjustedEndRad);
                ctx.lineWidth = lineWidth;
                ctx.strokeStyle = backgroundColor;
                ctx.stroke();
                // 绘制起始圆角
                let startX = x + (radius - lineWidth / 2) * Math.cos(adjustedStartRad);
                let startY = y + (radius - lineWidth / 2) * Math.sin(adjustedStartRad);
                ctx.beginPath();
                ctx.arc(startX, startY, cornerRadius, 0, Math.PI * 2);
                ctx.fillStyle = backgroundColor;
                ctx.fill();

                // 绘制结束圆角
                let endX = x + (radius - lineWidth / 2) * Math.cos(adjustedEndRad);
                let endY = y + (radius - lineWidth / 2) * Math.sin(adjustedEndRad);
                ctx.beginPath();
                ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                ctx.fillStyle = backgroundColor;
                ctx.fill();
            } else {
                ctx.beginPath();
                ctx.arc(canvas.width / 2, canvas.height / 2, radius - lineWidth / 2, startRad, endRad);
                ctx.lineWidth = lineWidth;
                ctx.strokeStyle = backgroundColor;
                ctx.stroke();
            }
            //用完之后恢复
            ctx.globalAlpha = 1
        }


        // 绘制前景进度圆弧
        if (showSegments) {
            // 分段绘制
            const segmentAngleRad = (totalAngle / segments) * Math.PI / 180;
            const segmentSpacing = (spacingPercentage / 100) * segmentAngleRad;
            const fullSegmentWidth = segmentAngleRad + segmentSpacing;
            const totalAngleRad = totalAngle * Math.PI / 180;
            const usableAngle = totalAngleRad * (progress / 100);
            const filledSegments = Math.floor(usableAngle / fullSegmentWidth);

            for (let i = 0; i < filledSegments; i++) {
                const centerX = canvas.width / 2;
                const centerY = canvas.height / 2;
                const radiusOffset = radius - lineWidth / 2;

                if (!rightToLeft) {
                    const segmentStart = startRad + i * fullSegmentWidth;
                    const segmentEnd = segmentStart + segmentAngleRad - segmentSpacing;

                    ctx.beginPath();
                    ctx.arc(centerX, centerY, radiusOffset, segmentStart, segmentEnd);
                } else {
                    const segmentStart = endRad - i * fullSegmentWidth;
                    const segmentEnd = segmentStart - (segmentAngleRad - segmentSpacing);

                    ctx.beginPath();
                    ctx.arc(centerX, centerY, radiusOffset, segmentStart, segmentEnd, true);
                }

                ctx.lineWidth = lineWidth;
                ctx.strokeStyle = foregroundColor;
                ctx.stroke();
            }
        } else {
            // 不分段绘制

            if (settings.titleParameters.roundCorner && !rightToLeft) {
                // // 计算圆弧的结束点 (用于圆角)
                // const x = canvas.width / 2
                // const y = canvas.height / 2
                // const cornerRadius = lineWidth / 2;  // 圆角的半径
                // let endX = x + (radius - lineWidth / 2) * Math.cos(startRad);
                // let endY = y + (radius - lineWidth / 2) * Math.sin(startRad);
                // // 绘制圆角（小圆）
                // ctx.beginPath();
                // ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                // ctx.fillStyle = foregroundColor;
                // ctx.fill();
                // const progressAngle = startRad + (endRad - startRad) * (progress / 100);
                // endX = x + (radius - lineWidth / 2) * Math.cos(progressAngle);
                // endY = y + (radius - lineWidth / 2) * Math.sin(progressAngle);
                // // 绘制圆角（小圆）
                // ctx.beginPath();
                // ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                // ctx.fillStyle = foregroundColor;
                // ctx.fill();
                const x = canvas.width / 2;
                const y = canvas.height / 2;
                const cornerRadius = lineWidth / 2;  // 圆角的半径

                // 缩短弧度，使圆角包含在原弧度范围内
                const adjustedStartRad = startRad + cornerRadius / radius;
                const adjustedEndRad = endRad - cornerRadius / radius;

                // 绘制起始圆角
                let startX = x + (radius - lineWidth / 2) * Math.cos(adjustedStartRad);
                let startY = y + (radius - lineWidth / 2) * Math.sin(adjustedStartRad);
                ctx.beginPath();
                ctx.arc(startX, startY, cornerRadius, 0, Math.PI * 2);
                ctx.fillStyle = foregroundColor;
                ctx.fill();

                // 绘制进度的弧线
                const progressAngle = adjustedStartRad + (adjustedEndRad - adjustedStartRad) * (progress / 100);
                ctx.beginPath();
                ctx.arc(x, y, radius - lineWidth / 2, adjustedStartRad, progressAngle);
                ctx.lineWidth = lineWidth;
                ctx.strokeStyle = foregroundColor;
                ctx.stroke();

                // 绘制结束圆角
                let endX = x + (radius - lineWidth / 2) * Math.cos(progressAngle);
                let endY = y + (radius - lineWidth / 2) * Math.sin(progressAngle);
                ctx.beginPath();
                ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                ctx.fillStyle = foregroundColor;
                ctx.fill();

            } else if (settings.titleParameters.roundCorner) {
                // 计算圆弧的结束点 (用于圆角)
                // const x = canvas.width / 2
                // const y = canvas.height / 2
                // const cornerRadius = lineWidth / 2;  // 圆角的半径
                // let endX = x + (radius - lineWidth / 2) * Math.cos(endRad);
                // let endY = y + (radius - lineWidth / 2) * Math.sin(endRad);
                // ctx.beginPath();
                // ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                // ctx.fillStyle = foregroundColor;
                // ctx.fill();
                // const progressAngle = endRad - (endRad - startRad) * (progress / 100);
                // endX = x + (radius - lineWidth / 2) * Math.cos(progressAngle);
                // endY = y + (radius - lineWidth / 2) * Math.sin(progressAngle);
                // // 绘制圆角（小圆）
                // ctx.beginPath();
                // ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                // ctx.fillStyle = foregroundColor;
                // ctx.fill();

                const x = canvas.width / 2;
                const y = canvas.height / 2;
                const cornerRadius = lineWidth / 2;  // 圆角的半径

                // 缩短结束和进度角度，避免圆角超出弧度
                const adjustedEndRad = endRad - cornerRadius / radius;
                const adjustedStartRad = startRad + cornerRadius / radius;

                // 绘制起始点的圆角
                let startX = x + (radius - lineWidth / 2) * Math.cos(adjustedEndRad);
                let startY = y + (radius - lineWidth / 2) * Math.sin(adjustedEndRad);
                ctx.beginPath();
                ctx.arc(startX, startY, cornerRadius, 0, Math.PI * 2);
                ctx.fillStyle = foregroundColor;
                ctx.fill();

                // 绘制进度弧线 (逆时针)
                const progressAngle = adjustedEndRad - (adjustedEndRad - adjustedStartRad) * (progress / 100);
                ctx.beginPath();
                ctx.arc(x, y, radius - lineWidth / 2, adjustedEndRad, progressAngle, true);
                ctx.lineWidth = lineWidth;
                ctx.strokeStyle = foregroundColor;
                ctx.stroke();

                // 绘制结束点的圆角
                let endX = x + (radius - lineWidth / 2) * Math.cos(progressAngle);
                let endY = y + (radius - lineWidth / 2) * Math.sin(progressAngle);
                ctx.beginPath();
                ctx.arc(endX, endY, cornerRadius, 0, Math.PI * 2);
                ctx.fillStyle = foregroundColor;
                ctx.fill();

            } else {
                ctx.beginPath();
                if (!rightToLeft) {
                    const progressAngle = startRad + (endRad - startRad) * (progress / 100); // 顺时针，进度从 startRad 到 endRad
                    ctx.arc(canvas.width / 2, canvas.height / 2, radius - lineWidth / 2, startRad, progressAngle);
                }
                // 逆时针绘制 (rightToLeft == true)
                else {
                    const progressAngle = endRad - (endRad - startRad) * (progress / 100); // 逆时针，进度从 endRad 到 startRad
                    ctx.arc(canvas.width / 2, canvas.height / 2, radius - lineWidth / 2, endRad, progressAngle, true);
                }
                ctx.lineWidth = lineWidth;
                ctx.strokeStyle = foregroundColor;
                ctx.stroke();
            }
        }

        //绘制文本
        if (settings.titleParameters.showTitle) {
            // 设置字体
            ctx.font = `${settings.titleParameters.fontSize - 5}px ${settings.titleParameters.fontFamily}`;  // 设置字体大小和字体类型
            ctx.fillStyle = settings.titleParameters.color;
            // 要绘制的文本
            const text = settings.titleParameters.showItem + ": " + this.data[context].text;
            ctx.textAlign = 'center';  // 水平居中
            ctx.textBaseline = 'center';  // 垂直居中
            ctx.fillText(text, canvas.width / 2, (canvas.height + settings.titleParameters.fontSize) / 2);
        }

        const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
        this.getContentSize(canvas, imageData, canvasWidth, context);
        // if (flag) {
        //     const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
        //     let { contentWidth, contentHeight } = this.getContentSize(imageData, canvasWidth);
        //     // console.log(contentWidth, contentHeight);
        //     this.draw(context, contentWidth, contentHeight, false)
        //     return
        // }
        // console.log(canvas.toDataURL("image/png"));
        // window.socket.setImage(context, canvas.toDataURL("image/png"));
    },
    getContentSize(originalCanvas, imageData, boundary, context) {//获取内容宽高
        const pixels = imageData.data;

        // 初始化边界
        let left = boundary, right = 0, top = boundary, bottom = 0;

        // 扫描像素数据，找出非透明像素的边界
        for (let i = 0; i < pixels.length; i += 4) {
            const x = (i / 4) % boundary;
            const y = Math.floor(i / 4 / boundary);

            const r = pixels[i];     // Red
            const g = pixels[i + 1]; // Green
            const b = pixels[i + 2]; // Blue
            const a = pixels[i + 3]; // Alpha

            // 只考虑非透明的像素
            if (a !== 0) {
                // 更新边界
                left = Math.min(left, x);
                right = Math.max(right, x);
                top = Math.min(top, y);
                bottom = Math.max(bottom, y);
            }
        }

        // 计算内容的宽度和高度
        const contentWidth = right - left + 1;
        const contentHeight = bottom - top + 1;

        // 创建新canvas来存放裁剪后的内容
        const croppedCanvas = document.createElement("canvas");
        croppedCanvas.width = contentWidth;
        croppedCanvas.height = contentHeight;
        this.data[context].ActionGeometry.width = contentWidth;
        this.data[context].ActionGeometry.height = contentHeight;
        const croppedCtx = croppedCanvas.getContext("2d");
        croppedCtx.globalAlpha = 1 - this.data[context].titleParameters.opacity;
        // 将裁剪的区域绘制到新canvas
        //const croppedImageData = originalCtx.getImageData(left, top, contentWidth, contentHeight);
        //croppedCtx.putImageData(croppedImageData, 0, 0);
        croppedCtx.drawImage(originalCanvas, left, top, contentWidth, contentHeight, 0, 0, contentWidth, contentHeight);
        window.socket.setImage(context, croppedCanvas.toDataURL("image/png"));
    }
});