/// <reference path="./utils/common.js" />
/// <reference path="./utils/axios.js" />


// 操作一
plugin.Type_7 = new Actions({
    default: {
        data: {}
    },
    isSettings: {},
    async _willAppear({ context, payload }) {
        // window.socket.setTitle(context, "Hello world!");
        try {
            this.isSettings[context] = true;
            //获取磁盘信息
            if (window.ws.readyState === WebSocket.OPEN) {
                window.ws?.send("drives");
                window.ws?.send("AllAudioEndpointVolume");
                window.ws?.send("Disk Temperature");
                window.ws?.send(mapping[this.data[context].titleParameters.showItem]);
            }
            this.calculate(context, this.data[context]);
            // 加载字体文件
            const settings = payload.settings;
            //  const fonts = JSON.parse(settings.fonts)
            //  settings.fontFamilys = []
            //  await Promise.all(
            //      fonts.map(async (font) => {
            //          settings.fontFamilys.push(font.name);
            //          // 判断字体是否已存在
            //          const isFontLoaded = [...document.fonts].some(
            //              (loadedFont) => loadedFont.family === font.name
            //          );

            //          if (isFontLoaded) {
            //              // console.log(`Font "${font.name}" is already loaded.`);
            //              return; // 如果字体已存在，则跳过加载
            //          }

            //          // 如果字体不存在，加载并添加
            //          const f = new FontFace(font.name, `url(${encodeURI(font.url)})`);

            //          try {
            //              const loadedFont = await f.load();
            //              document.fonts.add(loadedFont);
            //              // console.log(`Font "${font.name}" loaded successfully.`);
            //          } catch (error) {
            //              console.error(`Failed to load font "${font.name}":`, error);
            //          }
            //      })
            //  );
            //  console.log('font-settings', settings)
            //  delete settings.fonts;
            window.socket.setSettings(context, settings)
        } catch (error) {
            console.log(error);
        }
        plugin.setInterval(context, () => {
            try {
                if (window.ws.readyState === WebSocket.OPEN) {
                    window.ws?.send(mapping[this.data[context].titleParameters.showItem]);
                }
                this.calculate(context, this.data[context]);
                //更新VolumeNames、DriveNames
                this.updateDrives(context);
                //window.socket.setSettings(context, this.data[context])
            } catch (error) {
                console.log(error);
            }
        }, 500)
        setTimeout(() => {
            //更新VolumeNames、DriveNames
            this.updateDrives(context);
            window.socket.setSettings(context, this.data[context])
        }, 3000)
        if (payload.settings.titleParameters.showItem == "Hard Disk" && payload.settings.titleParameters.diskMode != "Single_Disk") {
            this.loop(context);
        } else {
            plugin.clearInterval(context + 1);
        }
    },
    _willDisappear({ context }) {
        plugin.clearInterval(context);
        plugin.clearInterval(context + 1);
    },
    didReceiveSettings({ context, payload }) {
        try {
            window.ws?.send(payload.settings.titleParameters.showItem);
        } catch (error) {
            console.log(error);
        }
        if (payload.settings.titleParameters.showItem == "Hard Disk" && payload.settings.titleParameters.diskMode != "Single_Disk") {
            this.loop(context);
        } else {
            plugin.clearInterval(context + 1);
        }
        this.calculate(context, payload.settings);
    },
    updateDrives(context) {
        this.data[context].DriveNames = []
        this.data[context].VolumeNames = []
        this.data[context].AudioNames = []
        this.data[context].AudioNameszf = [];
        this.data[context].diskList = [];
        info["drives"].forEach(item => {
            this.data[context].DriveNames.push(item.driveName);
            this.data[context].VolumeNames.push(item.volumeName);
        });
        info["AllAudioEndpointVolume"].forEach(item => {
            this.data[context].AudioNames.push(item.AudioNames);
            this.data[context].AudioNameszf.push(item.AudioNameszf);
        });
        let list = Object.keys(info["Disk Temperature"]);
        if (list.length > 0) {
            this.data[context].diskList = Object.keys(info["Disk Temperature"]);
        }
        this.isSettings[context] = false;
    },
    loop(context) {//磁盘循环
        plugin.clearInterval(context + 1);
        plugin.setInterval(context + 1, () => {
            try {
                this.data[context].titleParameters.volumeNameItem++
                if (this.data[context].titleParameters.volumeNameItem >= this.data[context].DriveNames.length) {
                    this.data[context].titleParameters.volumeNameItem = 0;
                }
            } catch (error) {
                console.log(error);
            }
        }, this.data[context].titleParameters.switchFrequency * 1000)
    },
    getProgress(name, context) {
        //获取进度并返回
        let progress = 50;

        try {
            if (name == "Memory Available") {//可用内存（获取的是内存使用率用100-已使用=可用）
                progress = 100 - parseInt(info[mapping[name]]);
                this.data[context].text = progress + "%";
            } else if (name == "System Volume") {
                progress = Math.round(this.data[context].AudioNameszf[this.data[context].titleParameters.select])||0;
                this.data[context].text = progress + "%";
            } else if (name == "Hard Disk") {//硬盘使用率,要特殊处理多个磁盘
                info[mapping[name]]
                if (this.data[context].titleParameters.diskMode == "Single_Disk") {//单个磁盘
                    progress = 100 - info[mapping[name]][this.data[context].titleParameters.volumeNameItem]?.freeSpacePercent
                    this.data[context].text = progress + "%";
                } else {//循环
                    progress = 100 - info[mapping[name]][this.data[context].titleParameters.volumeNameItem]?.freeSpacePercent
                    this.data[context].text = progress + "%";
                }
            } else {
                this.data[context].text = info[mapping[name]]
                progress = parseInt(info[mapping[name]]);
                if (mapping[name] == "Cpu Clock") {
                    progress = parseInt(info[mapping[name]]) / (5 * 1024) * 100;
                }
                if (mapping[name] == "Gpu Core Clock") {
                    progress = parseInt(info[mapping[name]]) / (5 * 1024) * 100;
                }
                if (mapping[name] == "Disk Temperature") {
                    // console.log('diskTemperature', info[mapping[name]], this.data[context].titleParameters['diskName']);
                    const diskObj = info[mapping[name]][this.data[context].titleParameters['diskName']];
                    let diskTemperature = diskObj?.['Drive Temperature'].value || diskObj?.['Drive Temperature 2'].value || 30;
                    this.data[context].text = diskTemperature + "°C";
                    progress = parseInt(diskTemperature);
                }
            }
        } catch (error) {
            console.log(error);
        }
        return progress;
    },

    calculate(context, settings) {
        const data = settings.titleParameters;
        if (this.isSettings[context] || settings.softwareSend) {
            const scale = settings.ActionGeometry.width / this.data[context].ActionGeometry.width;
            settings.titleParameters.fontSize = Math.round(data.fontSize * scale);
            settings.titleParameters.progressBarWidth = Math.round(data.progressBarWidth * scale);
            settings.titleParameters.progressBarHeight = Math.round(data.progressBarHeight * scale);
            settings.softwareSend = false;
            // this.isSettings[context] = false;
            this.updateDrives(context);
            window.socket.setSettings(context, settings)
        }
        this.data[context] = settings;
        if (settings.titleParameters.directionItem == "1") {
            this.draw1(context);
        } else if (settings.titleParameters.directionItem == "2") {
            this.draw0(context);
        } else if (settings.titleParameters.directionItem == "3") {
            this.draw1(context);
        } else {
            this.draw0(context);
        }
    },
    draw0(context, canvasWidth = 800, canvasHeight = 640, flag = true) {
        const settings = this.data[context];
        const progress = this.getProgress(settings.titleParameters.showItem, context);
        const canvas = document.createElement('canvas');
        const width = settings.titleParameters.progressBarWidth;
        const height = settings.titleParameters.progressBarHeight;

        canvas.width = canvasWidth;
        canvas.height = canvasHeight;
        const ctx = canvas.getContext('2d');
        // 清空画布
        ctx.clearRect(0, 0, canvas.width, canvas.height);

        ctx.globalAlpha = 1 - settings.titleParameters.opacity + 0.01

        // 背景条
        if (!settings.titleParameters.hideBackGround) {
            ctx.fillStyle = settings.titleParameters.backgroundColor;
            if (settings.titleParameters.roundCorner) {
                // 使用圆角矩形
                this.drawRoundedRect(ctx, 0, 0, width, height, 10); // radius=10，可以调整
                ctx.fill(); // 填充路径
            } else {
                ctx.fillRect(0, 0, width, height);
            }
        }

        if (settings.titleParameters.gradient) {
            // 创建渐变颜色（从上到下）
            const gradient = ctx.createLinearGradient(0, 0, 0, height); // 从顶部到底部的渐变
            gradient.addColorStop(0, settings.titleParameters.foregroundColor); // 渐变的起始颜色
            gradient.addColorStop(1, settings.titleParameters.gradientColor); // 渐变的结束颜色
            ctx.fillStyle = gradient;
        } else if (settings.titleParameters.gradient2) {
            const gradient = ctx.createLinearGradient(0, 0, width, 0); // 从左到右的渐变
            gradient.addColorStop(0, settings.titleParameters.foregroundColor); // 渐变的起始颜色
            gradient.addColorStop(1, settings.titleParameters.gradientColor); // 渐变的结束颜色
            ctx.fillStyle = gradient;
        } else {
            ctx.fillStyle = settings.titleParameters.foregroundColor;// 可以根据需要改变颜色
        }

        if (settings.titleParameters.section) {
            const segments = 20; // 分段数
            const spacingPercentage = 10; // 每段之间占用总长度的百分比（例如10%）

            // 计算间距总长度（间距占总宽度的百分比）
            const totalSpacing = (width * spacingPercentage) / 100;

            // 每段的实际宽度，减去间距后的宽度
            const segmentWidth = (width - totalSpacing) / segments;

            // 计算绘制的进度段数（根据进度百分比）
            const progressSegments = Math.ceil((progress / 100) * segments);
            for (let i = 0; i < progressSegments; i++) {
                // 计算每个段的起始位置，考虑间距
                let segmentStartX = i * (segmentWidth + totalSpacing / (segments - 1));
                if (settings.titleParameters.directionItem == "2") {
                    segmentStartX = width - (i + 1) * (segmentWidth + totalSpacing / (segments - 1));
                }
                // 绘制该段
                ctx.fillRect(segmentStartX, 0, segmentWidth, height);
            }
        } else {
            // ctx.fillRect(0, 0, width * progress / 100, height);
            if (settings.titleParameters.directionItem == "2") {
                // ctx.fillRect(width * (1 - progress / 100), 0, width * progress / 100, height);
                // 从右向左绘制圆角进度条
                if (settings.titleParameters.roundCorner) {
                    const progressWidth = width * progress / 100;
                    this.drawRoundedRect(ctx, width - progressWidth, 0, progressWidth, height, 10);
                } else {
                    ctx.fillRect(width * (1 - progress / 100), 0, width * progress / 100, height);
                }
            } else {
                // ctx.fillRect(0, 0, width * progress / 100, height);
                // 从左向右绘制圆角进度条
                if (settings.titleParameters.roundCorner) {
                    // 使用圆角矩形
                    this.drawRoundedRect(ctx, 0, 0, width * progress / 100, height, 10);
                } else {
                    ctx.fillRect(0, 0, width * progress / 100, height);
                }
            }
        }

        // 添加边框
        ctx.strokeStyle = settings.titleParameters.frameColor; // 边框颜色，默认为黑色
        ctx.lineWidth = 1; // 边框宽度
        // ctx.strokeRect(0.5, 0.5, width - 1, height - 1); // 绘制矩形边框
        if (settings.titleParameters.roundCorner) {
            this.drawRoundedRect(ctx, 0.5, 0.5, width - 1, height - 1, 10, true);
        } else {
            ctx.strokeRect(0.5, 0.5, width - 1, height - 1); // 绘制矩形边框 
        }
        // console.log(canvas.toDataURL("image/png"));

        if (settings.titleParameters.showTitle) {
            // 设置字体
            ctx.font = `${settings.titleParameters.fontSize}px ${settings.titleParameters.fontFamily}`;  // 设置字体大小和字体类型
            ctx.fillStyle = settings.titleParameters.color;
            // 要绘制的文本
            const text = settings.titleParameters.showItem + ": " + this.data[context].text;
            // console.log(text);
            ctx.textAlign = 'center';  // 水平居中
            ctx.textBaseline = 'top';  // 垂直居中
            // 获取文本宽度
            // textWidth = ctx.measureText(text).width;
            ctx.fillText(text, width / 2, height);
        }

        if (flag) {
            const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
            let { contentWidth, contentHeight } = this.getContentSize(imageData, canvasWidth);
            contentWidth = contentWidth > width ? width : contentWidth;
            // console.log(contentWidth, contentHeight);
            this.draw0(context, contentWidth, contentHeight, false)
            return
        }
        // console.log(canvas.toDataURL("image/png"));
        window.socket.setImage(context, canvas.toDataURL("image/png"));
    },
    draw1(context, canvasWidth = 640, canvasHeight = 800, flag = true) {
        const settings = this.data[context];
        const progress = this.getProgress(settings.titleParameters.showItem, context);
        const canvas = document.createElement('canvas');
        const width = settings.titleParameters.progressBarHeight;
        const height = settings.titleParameters.progressBarWidth;
        let textHeight = 0;
        if (settings.titleParameters.showTitle) {
            textHeight = settings.titleParameters.fontSize;
        }
        canvas.width = canvasWidth;
        const ctx = canvas.getContext('2d');
        let x = 0;
        if (settings.titleParameters.showTitle) {
            // 设置字体
            ctx.font = `${settings.titleParameters.fontSize}px ${settings.titleParameters.fontFamily}`;  // 设置字体大小和字体类型
            // 要绘制的文本
            const text = settings.titleParameters.showItem + ": " + this.data[context].text;
            // 获取文本宽度
            ctx.measureText(text).width > width ? x = (ctx.measureText(text).width - width) / 2 : null;
        }
        canvas.height = canvasHeight;

        // 清空画布
        ctx.clearRect(0, 0, width, height);

        ctx.globalAlpha = 1 - settings.titleParameters.opacity + 0.01;

        // 背景条
        if (!settings.titleParameters.hideBackGround) {
            ctx.fillStyle = settings.titleParameters.backgroundColor;
            if (settings.titleParameters.roundCorner) {
                // 使用圆角矩形
                this.drawRoundedRect(ctx, x, 0, width, height, 10); // radius=10，可以调整
                ctx.fill(); // 填充路径
            } else {
                ctx.fillRect(x, 0, width, height);
            }
        }

        // 前景条（显示进度）
        if (settings.titleParameters.gradient) {
            // 创建渐变颜色（从上到下）
            const gradient = ctx.createLinearGradient(0, 0, 0, height); // 从顶部到底部的渐变
            gradient.addColorStop(0, settings.titleParameters.foregroundColor); // 渐变的起始颜色
            gradient.addColorStop(1, settings.titleParameters.gradientColor); // 渐变的结束颜色
            ctx.fillStyle = gradient;
        } else if (settings.titleParameters.gradient2) {
            const gradient = ctx.createLinearGradient(0, 0, width, 0); // 从左到右的渐变
            gradient.addColorStop(0, settings.titleParameters.foregroundColor); // 渐变的起始颜色
            gradient.addColorStop(1, settings.titleParameters.gradientColor); // 渐变的结束颜色
            ctx.fillStyle = gradient;
        } else {
            ctx.fillStyle = settings.titleParameters.foregroundColor;// 可以根据需要改变颜色
        }

        if (settings.titleParameters.section) {
            const segments = 20; // 分段数
            const spacingPercentage = 10; // 每段之间占用总长度的百分比（例如10%）

            // 计算间距总长度（间距占总宽度的百分比）
            const totalSpacing = (height * spacingPercentage) / 100;

            // 每段的实际宽度，减去间距后的宽度
            const segmentHeight = (height - totalSpacing) / segments;

            // 计算绘制的进度段数（根据进度百分比）
            const progressSegments = Math.ceil((progress / 100) * segments);

            for (let i = 0; i < progressSegments; i++) {
                // 计算每个段的起始位置，考虑间距
                let segmentStarty = i * (segmentHeight + totalSpacing / (segments - 1));
                if (settings.titleParameters.directionItem == "3") {
                    segmentStarty = height - (i + 1) * (segmentHeight + totalSpacing / (segments - 1));
                }
                // 绘制该段
                ctx.fillRect(x, segmentStarty, width, segmentHeight);
            }
        } else {
            if (settings.titleParameters.directionItem == "3") {
                if (settings.titleParameters.roundCorner) {
                    // 使用圆角矩形
                    this.drawRoundedRect(ctx, x, height * (1 - progress / 100), width, height * progress / 100, 10); // radius=10，可以调整
                    ctx.fill(); // 填充路径
                } else {
                    ctx.fillRect(x, height * (1 - progress / 100), width, height * progress / 100);
                }

            } else {
                if (settings.titleParameters.roundCorner) {
                    // 使用圆角矩形
                    this.drawRoundedRect(ctx, x, 0, width, height * progress / 100, 10); // radius=10，可以调整
                    ctx.fill(); // 填充路径
                } else {
                    ctx.fillRect(x, 0, width, height * progress / 100);
                }
            }
        }

        // 添加边框
        ctx.strokeStyle = settings.titleParameters.frameColor; // 边框颜色，默认为黑色
        ctx.lineWidth = 1; // 边框宽度
        if (settings.titleParameters.roundCorner) {
            // 使用圆角矩形
            this.drawRoundedRect(ctx, x + 0.5, 0.5, width - 1, height - 1, 10, true);
        } else {
            ctx.strokeRect(x + 0.5, 0.5, width - 1, height - 1); // 绘制矩形边框
        }

        if (settings.titleParameters.showTitle) {
            // 设置字体
            ctx.font = `${settings.titleParameters.fontSize}px ${settings.titleParameters.fontFamily}`;  // 设置字体大小和字体类型
            ctx.fillStyle = settings.titleParameters.color;
            // 要绘制的文本
            const text = settings.titleParameters.showItem + ": " + this.data[context].text;
            ctx.textAlign = 'center';  // 水平居中
            ctx.textBaseline = 'top';  // 垂直居中
            // 获取文本宽度
            textWidth = ctx.measureText(text).width;
            let temp = width > textWidth ? width : textWidth;
            ctx.fillText(text, temp / 2, height);
        }
        if (flag) {
            // console.log(canvas.toDataURL("image/png"));

            const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
            let { contentWidth, contentHeight } = this.getContentSize(imageData, canvasWidth);
            contentWidth = contentWidth < width ? width : contentWidth;
            //更新存在这边的画布width用于计算缩放，不更新的就是上一个反向的数据差别很大
            this.data[context].ActionGeometry.width = contentWidth;
            // console.log(contentWidth, contentHeight);
            this.draw1(context, contentWidth, contentHeight, false)
            return
        }
        window.socket.setImage(context, canvas.toDataURL("image/png"));
    },
    getContentSize(imageData, boundary) {//获取内容宽高
        const pixels = imageData.data;

        // 初始化边界
        let left = boundary, right = 0, top = boundary, bottom = 0;

        // 扫描像素数据，找出非透明像素的边界
        for (let i = 0; i < pixels.length; i += 4) {
            const x = (i / 4) % boundary;
            const y = Math.floor(i / 4 / boundary);

            const r = pixels[i];     // Red
            const g = pixels[i + 1]; // Green
            const b = pixels[i + 2]; // Blue
            const a = pixels[i + 3]; // Alpha

            // 只考虑非透明的像素
            if (a !== 0) {
                // 更新边界
                left = Math.min(left, x);
                right = Math.max(right, x);
                top = Math.min(top, y);
                bottom = Math.max(bottom, y);
            }
        }

        // 计算内容的宽度和高度
        const contentWidth = right - left + 1;
        const contentHeight = bottom - top + 1;
        return { contentWidth, contentHeight };
    },
    drawRoundedRect(ctx, x, y, width, height, radius, isStroke = false) {
        ctx.beginPath();
        ctx.moveTo(x + radius, y); // 起点
        ctx.lineTo(x + width - radius, y); // 上边
        ctx.quadraticCurveTo(x + width, y, x + width, y + radius); // 右上角圆角
        ctx.lineTo(x + width, y + height - radius); // 右边
        ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height); // 右下角圆角
        ctx.lineTo(x + radius, y + height); // 下边
        ctx.quadraticCurveTo(x, y + height, x, y + height - radius); // 左下角圆角
        ctx.lineTo(x, y + radius); // 左边
        ctx.quadraticCurveTo(x, y, x + radius, y); // 左上角圆角
        ctx.closePath(); // 闭合路径

        if (isStroke) {
            ctx.stroke(); // 绘制边框
        } else {
            ctx.fill(); // 填充
        }
    }
});