/// <reference path="./utils/common.js" />
/// <reference path="./utils/axios.js" />

const plugin = new Plugins("System Performance Monitor");
const mapping = {
    "Cpu Usage": "Cpu Usage",//cpu使用率
    "Memory Usage": "Physical Memory Usage",//物理内存使用率
    "Gpu Core Usage": "Gpu Core Utility",//GPU使用率
    "Gpu Memory Usage": "Gpu Memory Utility",//GPU显存使用率
    //硬盘使用率,要特殊处理多个磁盘
    "Hard Disk": "drives",
    //"System Volume": "defaultAudioEndpointVolume",//默认音频设备的音量
    "System Volume": "AllAudioEndpointVolume",//默认音频设备的音量
    "Cpu Temperature": "Cpu Temperature",//cpu温度
    "Cpu Clock": "Cpu Clock",//cpu频率
    "Cpu Power": "Cpu Power",//cpu功耗
    "Gpu Temperature": "Gpu Temperature",//GPU温度
    "Gpu Clock": "Gpu Core Clock",//GPU核心频率
    "Gpu Power": "Gpu Power",//gpu功耗
    // 要处理
    "Memory Available": "Physical Memory Usage",//可用内存（获取的是内存使用率用100-已使用=可用）
    "Disk Temperature": "Disk Temperature",//硬盘温度
}
// 操作一
plugin.Type_1 = new Actions({
    default: {},
    isSettings: {},
    async _willAppear({ context, payload }) {
        // window.socket.setTitle(context, "Hello world!");
        try {
            this.isSettings[context] = true;
            //获取磁盘信息
            if (window.ws.readyState === WebSocket.OPEN) {
                window.ws?.send("drives");
                window.ws?.send("AllAudioEndpointVolume");
                window.ws?.send("Disk Temperature");
                window.ws?.send(mapping[this.data[context].titleParameters.showItem]);
                // const settings = payload.settings;
                // settings.softwareSend = true;
            }
            this.calculate(context, this.data[context], true);
            // // 加载字体文件
            // const fonts = JSON.parse(settings.fonts)
            // settings.fontFamilys = []
            // await Promise.all(
            //   fonts.map(async (font) => {
            //     settings.fontFamilys.push(font.name);
            //     // 判断字体是否已存在
            //     const isFontLoaded = [...document.fonts].some(
            //       (loadedFont) => loadedFont.family === font.name
            //     );

            //     if (isFontLoaded) {
            //       // console.log(`Font "${font.name}" is already loaded.`);
            //       return; // 如果字体已存在，则跳过加载
            //     }

            //     // 如果字体不存在，加载并添加
            //     const f = new FontFace(font.name, `url(${encodeURI(font.url)})`);

            //     try {
            //       const loadedFont = await f.load();
            //       document.fonts.add(loadedFont);
            //       // console.log(`Font "${font.name}" loaded successfully.`);
            //     } catch (error) {
            //       console.error(`Failed to load font "${font.name}":`, error);
            //     }
            //   })
            // );
            // console.log('font-settings', settings)
            // delete settings.fonts;
            // window.socket.setSettings(context, settings)
        } catch (error) {
            console.log(error);
        }
        plugin.setInterval(context, () => {
            try {
                if (window.ws.readyState === WebSocket.OPEN) {
                    window.ws?.send(mapping[this.data[context].titleParameters.showItem]);
                }
                this.calculate(context, this.data[context]);
                this.updateDrives(context);
                //window.socket.setSettings(context, this.data[context])
                // console.log('info', info);


            } catch (error) {
                console.log(error);
            }
        }, 500)

        setTimeout(() => {
            //更新VolumeNames、DriveNames
            this.updateDrives(context);
            // console.log(this.data[context]);

            window.socket.setSettings(context, this.data[context])
        }, 3000)

        if (payload.settings.titleParameters.showItem == "Hard Disk" && payload.settings.titleParameters.diskMode != "Single_Disk") {
            this.loop(context);
        } else {
            plugin.clearInterval(context + 1);
        }
    },
    _willDisappear({ context }) {
        plugin.clearInterval(context);
        plugin.clearInterval(context + 1);
    },
    didReceiveSettings({ context, payload }) {
        console.log('didReceiveSettings', payload);
        try {
            window.ws?.send(payload.settings.titleParameters.showItem);
        } catch (error) {
            console.log(error);
        }
        if (payload.settings.titleParameters.showItem == "Hard Disk" && payload.settings.titleParameters.diskMode != "Single_Disk") {
            this.loop(context);
        } else {
            plugin.clearInterval(context + 1);
        }
        this.calculate(context, payload.settings);
    },
    updateDrives(context) {
        this.data[context].DriveNames = []
        this.data[context].VolumeNames = []
        this.data[context].AudioNames = []
        this.data[context].AudioNameszf = [];
        this.data[context].diskList = [];
        info["drives"].forEach(item => {
            this.data[context].DriveNames.push(item.driveName);
            this.data[context].VolumeNames.push(item.volumeName);
        });
        // console.log('info', info);
        info["AllAudioEndpointVolume"].forEach(item => {
            this.data[context].AudioNames.push(item.AudioNames);
            this.data[context].AudioNameszf.push(item.AudioNameszf);
        });
        let list = Object.keys(info["Disk Temperature"]);
        if (list.length > 0) {
            this.data[context].diskList = Object.keys(info["Disk Temperature"]);

        }
        this.isSettings[context] = false;
        // if (mapping[this.data[context].titleParameters.showItem] == "Disk Temperature") {

        // }
    },
    loop(context) {//磁盘循环
        plugin.clearInterval(context + 1);
        plugin.setInterval(context + 1, () => {
            try {
                this.data[context].titleParameters.volumeNameItem++
                if (this.data[context].titleParameters.volumeNameItem >= this.data[context].DriveNames.length) {
                    this.data[context].titleParameters.volumeNameItem = 0;
                }
            } catch (error) {
                console.log(error);
            }
        }, this.data[context].titleParameters.switchFrequency * 1000)
    },
    getProgress(name, context) {
        //获取进度并返回
        let progress = 50;

        try {
            if (name == "Memory Available") {//可用内存（获取的是内存使用率用100-已使用=可用）
                progress = 100 - parseInt(info[mapping[name]]);
                this.data[context].text = progress + "%";
            } else if (name == "System Volume") {
                progress = Math.round(this.data[context].AudioNameszf[this.data[context].titleParameters.select]) || 0;
                this.data[context].text = progress + "%";
            } else if (name == "Hard Disk") {//硬盘使用率,要特殊处理多个磁盘
                info[mapping[name]]
                if (this.data[context].titleParameters.diskMode == "Single_Disk") {//单个磁盘
                    progress = 100 - info[mapping[name]][this.data[context].titleParameters.volumeNameItem]?.freeSpacePercent
                    this.data[context].text = progress + "%";
                } else {//循环
                    progress = 100 - info[mapping[name]][this.data[context].titleParameters.volumeNameItem]?.freeSpacePercent
                    this.data[context].text = progress + "%";
                }
            } else {
                this.data[context].text = info[mapping[name]]
                progress = parseInt(info[mapping[name]]) || 0;
                if (mapping[name] == "Cpu Clock") {
                    progress = parseInt(info[mapping[name]]) / (5 * 1024) * 100;
                }
                if (mapping[name] == "Gpu Core Clock") {
                    progress = parseInt(info[mapping[name]]) / (5 * 1024) * 100;
                }
                if (mapping[name] == "Disk Temperature") {
                    // console.log('diskTemperature', this.data[context].titleParameters['diskName']);
                    const diskObj = info[mapping[name]][this.data[context].titleParameters['diskName']];
                    let diskTemperature = diskObj?.['Drive Temperature'].value || diskObj?.['Drive Temperature 2'].value || 30;
                    this.data[context].text = diskTemperature + "°C";
                    progress = parseInt(diskTemperature);
                }
            }
        } catch (error) {
            console.log(error);
        }
        return progress;
    },
    calculate(context, settings) {
        const data = settings.titleParameters;
        // console.log('data', data);
        if (this.isSettings[context] || settings.softwareSend) {
            const scale = settings.ActionGeometry.width / this.data[context].ActionGeometry.width;
            settings.titleParameters.fontSize = Math.round(data.fontSize * scale);
            settings.titleParameters.progressBarWidth = Math.round(data.progressBarWidth * scale);
            settings.titleParameters.progressBarHeight = Math.round(data.progressBarHeight * scale);
            // this.isSettings[context] = false;
            settings.softwareSend = false;
            this.updateDrives(context);
            window.socket.setSettings(context, settings);
        }
        this.data[context] = settings;
        this.draw(context, this.data[context].titleParameters.progressBarWidth, this.data[context].titleParameters.progressBarHeight + this.data[context].titleParameters.fontSize);
    },
    async draw(context, canvasWidth, canvasHeight) {
        const settings = this.data[context];
        const progress = this.getProgress(settings.titleParameters.showItem, context);
        const canvas = document.createElement('canvas');
        canvas.width = canvasWidth;
        canvas.height = canvasHeight;
        const width = settings.titleParameters.progressBarWidth;
        const height = settings.titleParameters.progressBarHeight;

        const ctx = canvas.getContext('2d');

        const image = await loadImage("../images/actions/progressBar/Type_1.png");

        ctx.clearRect(0, 0, canvas.width, canvas.height);

        //绘制背景
        ctx.globalAlpha = 0.3;
        ctx.drawImage(image, 0, 0, width, height);


        ctx.globalAlpha = 1 - settings.titleParameters.opacity;
        // ctx.drawImage(image, 0, 0, width * progress / 100, height);
        if (settings.titleParameters.rightToLeft) {
            // 从画布的右侧开始绘制图像
            const progressWidth = width * progress / 100;
            ctx.drawImage(image, image.width * (1 - progress / 100), 0, image.width * progress / 100, image.height, width - progressWidth, 0, progressWidth, height);
        } else {
            ctx.drawImage(image, 0, 0, image.width * progress / 100, image.height, 0, 0, width * progress / 100, height);
        }

        //绘制文本
        if (settings.titleParameters.showTitle) {
            // 设置字体
            ctx.font = `${settings.titleParameters.fontSize}px ${settings.titleParameters.fontFamily}`;  // 设置字体大小和字体类型
            ctx.fillStyle = settings.titleParameters.color;
            // 要绘制的文本
            const text = settings.titleParameters.showItem + ": " + this.data[context].text;
            ctx.textAlign = 'center';  // 水平居中
            ctx.textBaseline = 'top';
            ctx.fillText(text, canvas.width / 2, height);
        }
        // console.log(canvas.width, canvas.height);

        const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
        this.getContentSize(canvas, imageData, canvasWidth, context);
    },
    getContentSize(originalCanvas, imageData, boundary, context) {//获取内容宽高
        const pixels = imageData.data;

        // 初始化边界
        let left = boundary, right = 0, top = boundary, bottom = 0;

        // 扫描像素数据，找出非透明像素的边界
        for (let i = 0; i < pixels.length; i += 4) {
            const x = (i / 4) % boundary;
            const y = Math.floor(i / 4 / boundary);

            const r = pixels[i];     // Red
            const g = pixels[i + 1]; // Green
            const b = pixels[i + 2]; // Blue
            const a = pixels[i + 3]; // Alpha

            // 只考虑非透明的像素
            if (a !== 0) {
                // 更新边界
                left = Math.min(left, x);
                right = Math.max(right, x);
                top = Math.min(top, y);
                bottom = Math.max(bottom, y);
            }
        }

        // 计算内容的宽度和高度
        const contentWidth = right - left + 1;
        const contentHeight = bottom - top + 1;

        // 创建新canvas来存放裁剪后的内容
        const croppedCanvas = document.createElement("canvas");
        croppedCanvas.width = contentWidth;
        croppedCanvas.height = contentHeight * 2;
        const croppedCtx = croppedCanvas.getContext("2d");
        croppedCtx.globalAlpha = 1 - this.data[context].titleParameters.opacity;
        // 将裁剪的区域绘制到新canvas
        //const croppedImageData = originalCtx.getImageData(left, top, contentWidth, contentHeight);
        //croppedCtx.putImageData(croppedImageData, 0, 0);
        //console.log(this.data[context].titleParameters.progressBarWidth, contentHeight);
        this.data[context].ActionGeometry.width = contentWidth;
        croppedCtx.drawImage(originalCanvas, left, top, this.data[context].titleParameters.progressBarWidth, contentHeight, 0, (croppedCanvas.height - contentHeight) / 2, this.data[context].titleParameters.progressBarWidth, contentHeight);
        window.socket.setImage(context, croppedCanvas.toDataURL("image/png"));
    }
});

const loadImage = (url) => {
    return new Promise((resolve, reject) => {
        const image = new Image();
        image.onload = () => resolve(image);
        image.src = url;
    });
}