export function Name() {
	return 'case fan';
  }
  export function VendorId() {
	return 26115;
  }
  export function ProductId() {
	return 2;
  }
  export function Type() {
	return 'fan';
  }
  export function Publisher() {
	return 'czy';
  }
  export function Fps() {
	return 30;
  }
  export function ControllableParameters() {
	return [
	  { property: 'shutdownColor', group: 'lighting', label: 'Shutdown Color', min: '0', max: '360', type: 'color', default: '009bde' },
	  { property: 'forcedColor', group: 'lighting', label: 'Forced Color', min: '0', max: '360', type: 'color', default: '009bde' }
	];
  }
  
  var ChannelArray = [['case fan', 24]];
 /**
   * @author  nzw 灯珠数量修改
   * @time  2024/10/16
   * @param number 修改的灯珠数量
   * @param id 修改第几通道数据
  */
  //   灯珠数量修改
  export function onLampLedModify(number,id=0) {
	  ChannelArray = [['case fan', number]];
	//   console.log(number,'灯珠数量修改===11111',ChannelArray)
	// device.modifyChannel(ChannelArray[0][0], ChannelArray[0][1],'id_'+0);
  }
  
  function SetupChannels() {
	// device.SetLedLimit(48);
	for (let i = 0; i < ChannelArray.length; i++) {
		// console.log('灯珠数量修改===2222',device)
	  device.addChannel(ChannelArray[i][0], ChannelArray[i][1],'id_'+i);
	}
  }
  
  export function Initialize() {
	SetupChannels();
  }
  
  function sendColors(name) {
	let shutdown = false;
	var color;
  
	if (shutdown) {
	  color = hexToRgb(shutdownColor);
	} else {
	  color = device.channel(name).getColors('Inline', 'RGB');
	}
  
	return color;
	//64为字节数
	// console.log(packet);
	//   device.write(Uint8Array.from(packet),64);
  }
  
  export function Render() {
	let packet = [];
	packet[0] = 65;
	// packet.push(0);
  
	// for (let o = 0; o < ChannelArray.length; o++) {
	packet[1] = ChannelArray[0][1];
	packet[2] = 0;
	// }
  
	for (let i = 0; i < ChannelArray.length; i++) {
	  device.channel(ChannelArray[i][0]).LedLimit(ChannelArray[i][1]);
	  packet = packet.concat(sendColors(ChannelArray[i][0]).reverse());
	}
	packet.push(0x01);
	packet = packet.flat();
	// console.log(ChannelArray[0],'灯珠数量nzw',packet)
	for (let i = 0; i < packet.length; i += 64) {
	  const data = packet.slice(i, i + 64);
	  // data.unshift(1);
	  device.write(data, 64);
	  // device.send_report( 0x01,data,64);
	}
  }
  
  export function Shutdown() {
	let packet = [];
	packet[0] = 65;
	packet[1] = ChannelArray[0][1];
	packet[2] = 0;
	for (let i = 0; i < ChannelArray.length * ChannelArray[i][1]; i++) {
	  packet.push(255, 255, 255);
	}
	packet.push(0x01);
	packet = packet.flat();
	// packet = packet.flat(1);
	for (let i = 0; i < packet.length; i += 64) {
	  const data = packet.slice(i, i + 64);
	  // data.unshift(1);
	  device.write(data, 64);
	  // device.send_report( 0x01,data,64);
	}
  }
  
  function hexToRgb(hex) {
	let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
	let colors = [];
	colors[0] = parseInt(result[1], 16);
	colors[1] = parseInt(result[2], 16);
	colors[2] = parseInt(result[3], 16);
  
	return colors;
  }
  
  export function Validate() {
	return { type: 0, usage: 0x0001, usagePage: 0x000c };
  }
  
  export function Image() {
	return '';
  }
  