export function Name() { return "FREQCHIP-HID"; }
export function VendorId() { return 26115; }
export function ProductId() { return 1; }
export function Type() { return 'Lamp'; }
export function Publisher() { return "czy"; }
export function Fps() { return 20; }
export function ControllableParameters() {
	return [
		{ "property": "shutdownColor", "group": "lighting", "label": "Shutdown Color", "min": "0", "max": "360", "type": "color", "default": "009bde" },
		{ "property": "forcedColor", "group": "lighting", "label": "Forced Color", "min": "0", "max": "360", "type": "color", "default": "009bde" },
	];
}

var ChannelArray = [
	["左灯", 23],
	["右灯", 23]
]
//历史灯珠数
var defaultLED = []
  // 初始化有多少个灯数据
export function dateLength() {
    return ChannelArray.map((item, index)=>{
      return {
        id:'id_'+index,
        name:item[0],
      }
  })
}

function SetupChannels() {
	device.SetLedLimit(48);
	for (let i = 0; i < ChannelArray.length; i++) {
		device.addChannel(ChannelArray[i][0], ChannelArray[i][1],'id_'+i);
	}
}

export function Initialize() {

	SetupChannels();
}


function sendColors(name) {

	let shutdown = false;
	var color;

	if (shutdown) {
		color = hexToRgb(shutdownColor);
	}
	else {
		color = device.channel(name).getColors('Inline', 'RGB');
	}
	return color;
	//64为字节数
	// console.log(packet);
	//   device.write(Uint8Array.from(packet),64);
}
function supplementValue(data,length) {
	let newArray = data
	for (let i = 0; i < length; i++) {
		newArray.push([0,0,0])
	}
	return newArray;

}

export function Render() {
	let packet = [];
	packet[0] = 65;
	// if(defaultLED.length <1){

	// 	// defaultLED = ChannelArray
	// 	defaultLED = [["左灯", 24],
	// 	["右灯", 24]]
	// }
	
	for (let o = 0; o < ChannelArray.length; o++) {
	packet[o+1] = ChannelArray[o][1];
	// for (let o = 0; o < defaultLED.length; o++) {
	// 	packet[o+1] = defaultLED[o][1];
	}
	for (let i = 0; i < ChannelArray.length; i++) {
		device.channel(ChannelArray[i][0]).LedLimit(ChannelArray[i][1])
    //    let dataArray = sendColors(ChannelArray[i][0])

	//    if(dataArray.length > ChannelArray[i][1]){
	// 	   // 采集的灯珠数据大于灯珠数，需要删除数据
	// 	//    dataArray.slice(0, ChannelArray[i][1])
	// 	   console.log('颜色数据----11111',JSON.parse(JSON.stringify(dataArray)) )

	//    }else if(dataArray.length < ChannelArray[i][1]){
	// 	   // 采集的灯珠数据小于灯珠数，需要补数据[0,0,0]
	// 	//    let lengthdz = ChannelArray[i][1] - dataArray.length
	// 	//    dataArray = supplementValue(dataArray,lengthdz)
	// 	   console.log('颜色数据----22222',JSON.parse(JSON.stringify(dataArray)) )
	//    }

	//    if(ChannelArray[i][1] < defaultLED[i][1]){
	// 	 let lengthdzNew = defaultLED[i][1] - dataArray.length
	// 	 dataArray = supplementValue(dataArray,lengthdzNew)
	// 	 defaultLED[i][1] = ChannelArray[i][1]
	//    }
	//    packet = packet.concat(dataArray.reverse());
	


		packet = packet.concat(sendColors(ChannelArray[i][0]).reverse());
	}
	packet.push(0x01);
	packet = packet.flat();

	// console.log('颜色数据----packet----999',packet)
	for (let i = 0; i < packet.length; i += 64) {
		const data = packet.slice(i, i + 64);
		// data.unshift(1);



	
		device.write(data, 64);
		// device.send_report( 0x01,data,64);
	}
}

export function Shutdown() {
	let packet = [];
	packet[0] = 65;
	for (let o = 0; o < ChannelArray.length; o++) {
		packet[o+1] = ChannelArray[o][1];
	}
	for (let i = 0; i < ChannelArray.length*24; i++) {
		packet.push(255,255,255);
	}
	packet.push(0x01);
	packet = packet.flat();
	// packet = packet.flat(1);
	for (let i = 0; i < packet.length; i += 64) {
		const data = packet.slice(i, i + 64);
		// data.unshift(1);
		device.write(data, 64);
		// device.send_report( 0x01,data,64);
	}
}

function hexToRgb(hex) {
	let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
	let colors = [];
	colors[0] = parseInt(result[1], 16);
	colors[1] = parseInt(result[2], 16);
	colors[2] = parseInt(result[3], 16);

	return colors;
}

export function Validate() {
	return { type: 0, usage: 0x0001, usagePage: 0x000c };
}

export function Image() {
	return "";
}

