/**
 * 基础参数说明:
 *      @local 是否国际化
 *      @back 自主决定回显时机
 *      @dom 保存需要的文档元素
 *      @propEvent 软件回调事件 - 策略模式
 * ==================================================>
 */
const $local = true, $back = false,
    $dom = {
        main: $('.sdpi-wrapper'),
        titleWrap: $('#titleWrap'),
        // tempList: $('#tempList'),
        inputCity: $('#inputCity'),
        inputTitle: $('#inputTitle'),
        theme: $('#theme'),
        searchBtn: $('#searchBtn'),
        searchList: $('#searchList'),
        color: $('#color'),
        opacity: $('#opacity'),
        // colorLabel: $('#color-label'),
        radio: $('.radioShow', true),
        tempList: $('.rdio1', true),
        apiList: $('.rdio2', true),
        X: $('#X'),
        Y: $('#Y'),
    },
    $propEvent = {
        didReceiveSettings() {
            $dom.opacity.value = $settings.opacity;
            updateProgress()
            $dom.X.value = $settings.x;
            $dom.Y.value = $settings.y;
            // $dom.searchList.innerHTML = ($settings.searchList || []).map(item => {
            //     return `<option value="${item.id}">${item.name}</option>`;
            // }).join('');
            if ($settings.searchList) {
                const list = $settings.searchList;
                const listEl = document.getElementById('searchList');
                if (window.choicesInstance) {
                    window.choicesInstance.destroy();
                }
                // 创建 Choices 实例
                window.choicesInstance = new Choices(listEl, {
                    searchEnabled: true,   // 开启搜索
                    itemSelectText: '',    // 去掉选中时的辅助文字
                    shouldSort: false      // 保持原始顺序
                });
                window.choicesInstance.input?.element.addEventListener('focus', () => {
                    // 输入框获取焦点后设置超出隐藏（干掉最外层滚动）
                    document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                    document.querySelector('.sdpi-wrapper').style.overflowY = "hidden";
                    document.body.style.overflowY = "hidden";
                    window.choicesInstance.containerOuter.element.scrollIntoView({
                        behavior: 'smooth', // 平滑滚动，可选
                        block: 'start'      // 滚动到顶部
                    });
                });
                window.choicesInstance.input?.element.addEventListener('blur', () => {
                    // 输入框失去焦点后恢复滚动
                    document.querySelector('.sdpi-wrapper').style.height = "100vh!important";
                    document.querySelector('.sdpi-wrapper').style.overflowY = "scroll";
                    document.body.style.overflowY = "scroll";
                });
                // 添加选项
                window.choicesInstance.setChoices(
                    list.map(item => ({
                        value: item.id,
                        label: item.name,
                        selected: item.id === ($settings.cityId || list[0].id)
                    })),
                    'value',
                    'label',
                    true // resetChoices: true
                );
            }
            // $dom.tempList.value = $settings.tempList || '0';
            $dom.tempList.forEach(item =>
                item.checked = item.value === ($settings.tempList || '0') ? true : false);
            $dom.apiList.forEach(item =>
                item.checked = item.value === ($settings.apiList || 'qweather') ? true : false);
            $dom.inputCity.value = $settings.inputCity || '';
            $dom.inputTitle.value = $settings.title || '';
            // $dom.searchList.value = $settings.cityId || '';
            $dom.theme.value = $settings.theme || 'right';
            $dom.color.value = $settings.color || '#ffffff';
            // $dom.colorLabel.style.backgroundColor = $settings.color
            titleWrap.style.display = ($settings.radio || '0') == '0' ? 'none' : 'flex';
            $dom.radio.forEach(item =>
                item.checked = item.value === ($settings.radio || '0') ? true : false);
        },
        sendToPropertyInspector(data) { }
    };

// 从这里开始...
$dom.radio.forEach(item => item.on('change', function () {
    $settings.radio = this.value;
    $websocket.sendToPlugin({ radio: this.value });
    titleWrap.style.display = this.value == '0' ? 'none' : 'flex';
}));
let qtObject = null;
let flag = true;
new QWebChannel(qt.webChannelTransport, function (channel) {
    // console.log('channel', channel);
    qtObject = channel.objects.channelqtObject;
    qtObject.sigDidReceiveCoordinate.connect((xx, yy) => {
        // console.log("sigDidReceiveCoordinate:", xx, yy);
        $dom.X.value = Math.round(xx);
        $dom.Y.value = Math.round(yy);
        flag = true
    })
})
// 坐标轴输入框改变事件

if (!Element.prototype.replaceChildren) {
    Element.prototype.replaceChildren = function (...nodes) {
        while (this.firstChild) {
            this.removeChild(this.firstChild);
        }
        this.append(...nodes);
    };
}

const handleChangeXY = () => {
    // const x = $('#X').value;
    // const y = $('#Y').value;

    // console.log('qtObject', qtObject)
    qtObject.uDidReceiveCoordinate(parseInt($dom.X.value), parseInt($dom.Y.value));
}
// 监听 方向键按下
const handleKeydown = (event) => {
    // 判断当前焦点是否是输入框
    const activeElement = document.activeElement;
    const isInputFocused = activeElement && (activeElement.tagName === "INPUT" || activeElement.tagName === "TEXTAREA");

    // 如果输入框获取了焦点，直接返回
    if (isInputFocused || !flag) {
        return;
    }
    flag = false;
    let x = parseInt($dom.X.value);
    let y = parseInt($dom.Y.value);
    switch (event.key) {
        case "ArrowUp":
            y -= 1;
            // console.log('ArrowUp:x-y', x + '-' + y);
            event.preventDefault();
            break;
        case "ArrowDown":
            y += 1;
            event.preventDefault();
            // console.log('ArrowDown:x-y', x + '-' + y);
            break;
        case "ArrowLeft":
            x -= 1;
            event.preventDefault();
            // console.log('ArrowLeft:x-y', x + '-' + y);
            break;
        case "ArrowRight":
            x += 1;
            event.preventDefault();
            // console.log('ArrowRight:x-y', x + '-' + y);
            break;
    }
    qtObject.uDidReceiveCoordinate(x, y);
}
window.addEventListener("keydown", handleKeydown);
// 防抖查询城市列表
const searchFunc = $.debounce(() => {
    $websocket.sendToPlugin({ inputCity: $dom.inputCity.value });
}, 1000);
$dom.inputCity.on('input', () => {
    searchFunc();
    $settings.inputCity = $dom.inputCity.value;
});

// 切换温度单位
$dom.tempList.forEach(item => item.on('change', function () {
    $settings.tempList = this.value;
    $websocket.sendToPlugin({ tempList: this.value });
}));
// 切换API单位
$dom.apiList.forEach(item => item.on('change', function () {
    $settings.apiList = this.value;
    $websocket.sendToPlugin({ apiList: this.value });
}));
// $dom.tempList.on('change', () => {
//     $settings.tempList = $dom.tempList.value;
//     $websocket.sendToPlugin({ tempList: $dom.tempList.value });
// });

// 搜索天气
$dom.searchList.on('change', () => {
    $settings.cityId = $dom.searchList.value;
    $websocket.sendToPlugin({ cityId: $dom.searchList.value });
});
$dom.searchBtn.on('click', () => {
    $websocket.sendToPlugin({ cityId: $dom.searchList.value });
});

// 自定义标题
$dom.inputTitle.on('input', () => {
    $settings.title = $dom.inputTitle.value;
    $websocket.sendToPlugin({ title: $dom.inputTitle.value });
});

// 主题切换
$dom.theme.on('change', () => {
    $settings.theme = $dom.theme.value;
    $websocket.sendToPlugin({ theme: $dom.theme.value });
});

$dom.color.on('change', () => {
    $settings.color = $dom.color.value;
    // $dom.colorLabel.style.backgroundColor = $settings.color
    $websocket.sendToPlugin({ color: $dom.color.value });
});

$dom.opacity.on('input', () => {
    console.log($dom.opacity.value);

    $settings.opacity = $dom.opacity.value;
    $websocket.sendToPlugin({ opacity: $dom.opacity.value });
});

$dom.opacity.on('input', () => {
    updateProgress();
    $settings.opacity = $dom.opacity.value;
    $websocket.sendToPlugin({ opacity: $dom.opacity.value });
});

const updateProgress = () => {
    // $settings.opacity = $dom.opacity.value;
    const value = $settings.opacity / 100 * 100;
    document.querySelector('input[type="range"]').style.setProperty('--progress-width', `${value}%`);
    // $websocket.sendToPlugin({ opacity: $dom.opacity.value });
}

const onWheel = (e) => {
    e.preventDefault();
    const step = e.deltaY < 0 ? 1 : -1;
    $('#opacity').value = Math.max(0, Math.min(100, parseInt($('#opacity').value) + step));
    updateProgress();
    $settings.opacity = $dom.opacity.value;
    $websocket.sendToPlugin({ opacity: $dom.opacity.value });
}

$('#opacity').addEventListener('mouseenter', () => {
    $('#opacity').addEventListener('wheel', onWheel);
});


$('#opacity').addEventListener('mouseleave', () => {
    $('#opacity').removeEventListener('wheel', onWheel);
});