/**
 * 基础参数说明:
 *      @plugin 全局插件行动 - 策略模式
 *      @plugin .default 行动默认数据
 *      @plugin _willAppear 在 willAppear 方法之后立即执行
 *      @plugin _willDisappear 在 willDisappear 方法之前立即执行
 *      @common sendToPlugin keyUp propertyInspectorDidAppear
 * =========================================================================>
 */
var { pinyin } = pinyinPro;
$plugin.action3 = new Action({
    default: {
        inputCity: "",
        tempList: "0",
        apiList:"qweather",
        cityId: "",
        city: "",
        title: "",
        opacity: 0,
        color: "#ffffff",
        radio: "0",
        searchList: [],
        theme: "right",
        wdata: { tmp: "20", code: "101" },
        titleParameters: {
            titleColor: "#ffffff",
        },
        count: 0,
        ActionGeometry: {
            width: '126',
            height: '126',
        },
        Localization: {}
    },
    /**
     *  1. 和风开发者KEY: 641403ded7f348bf88681308e648bdde
     *  2. 和风官方地理位置KEY: bdd98ec1d87747f3a2e8b1741a5af796
     *  3. 和风官方网页查询数据: https://www.qweather.com/v2/current/condition/s/x-cityId.html
     */
    async queryLocation(context, device) {
        const data = this.data[context];
        console.log("location",data)
        // 语言映射
        const langMap = {
            'zh_CN': 'zh', // 中文
            'en': 'en',    // 英文
            'ja': 'ja',    // 日文
            'fr': 'fr',    // 法文
            'it': 'it',    // 意大利文
            'ru': 'ru',    // 俄文
            'es': 'es',    // 西班牙文
            'pt': 'pt',    // 葡萄牙文
            'de': 'de'     // 德文
        };

        // 使用插件的当前语言，默认是英文
        const lang = langMap[$lang] || 'en';
        if(data.apiList=="qweather"){
            try {
                if (data.inputCity) {
                    $websocket.setTitle(context, "Loading");
                    // const lang = $lang == "zh_CN" ? "zh" : "en";
                    const key = "bdd98ec1d87747f3a2e8b1741a5af796";
                    const res = await axios(
                        `https://geoapi.qweather.com/v2/city/lookup?location=${data.inputCity}&key=${key}&lang=${lang}`, {
                        timeout: 3000,
                    }
                    );
                    if (res.data.code === "200") {
                        data.searchList = res.data.location;
                        this.queryWeather(context, device);
                        data.count = 0;
                    } else if (res.data.code === "404" || res.data.code === "400") {
                        data.searchList = [];
                        this.canvasFunc(context, device, "404");
                        $websocket.setSettings(context, data);
                    } else {
                        data.searchList = [];
                        this.canvasFunc(context, device, "error");
                        $websocket.setSettings(context, data);
                    }
                }
            } catch (e) {
                if (++data.count <= 3) {//重试3次
                    this.queryLocation(context, device);
                    $websocket.setTitle(context, "Try again");
                    return;
                }

                this.canvasFunc(context, device, "error");
            }
        }
        else{
            try {
                if (data.inputCity) {
                    const key = "c4aeca457d9e4a36a9982404252804";
                    $websocket.setTitle(context, "Loading");
                    let pinyinQuery = pinyin(data.inputCity,{"toneType": "none",separator: ''})
                    const res = await axios(
                        `http://api.weatherapi.com/v1/search.json?key=${key}&q=${pinyinQuery}&lang=${lang}`,
                        { timeout: 3000 }
                    );
                    let result = res.data.map(i => {
                        i.id = `${i.id}`;
                        return i;
                    })
                    
                    if (result && result.length > 0) {
                        data.searchList = result;
                        this.queryWeather(context, device);
                        data.count = 0;
                    }else {
                        data.searchList = [];
                        this.canvasFunc(context, device, "404");
                        $websocket.setSettings(context, data);
                    }

                }
            } catch (e) {
                if (++data.count <= 3) {//重试3次
                    // this.queryLocation(context, device);
                    $websocket.setTitle(context, "Try again");
                    return;
                }

                this.canvasFunc(context, device, "error");
            }
        }
        
    },
    // 请求天气
    async queryWeather(context, device) {
        const data = this.data[context];
        const langMap = {
            'zh_CN': 'zh', // 中文
            'en': 'en',    // 英文
            'ja': 'ja',    // 日文
            'fr': 'fr',    // 法文
            'it': 'it',    // 意大利文
            'ru': 'ru',    // 俄文
            'es': 'es',    // 西班牙文
            'pt': 'pt',    // 葡萄牙文
            'de': 'de'     // 德文
        };
        const lang = langMap[$lang] || 'en';
        try {
            clearTimeout(data.timer);
            // 过滤出用户选择的城市
            data.cityId = (
                data.searchList.filter((item) => item.id === data.cityId)[0] ||
                data.searchList[0]
            )?.id;
            data.city = data.searchList.filter(
                (item) => item.id === data.cityId
            )[0]?.name;
            data.fxLink = (
                data.searchList.filter((item) => item.id === data.cityId)[0] ||
                data.searchList[0]
            )?.fxLink;
            if (data.cityId) {
                if(data.apiList=="qweather"){
                    $websocket.setTitle(context, "Loading");
                    const res = await axios(
                    data.fxLink, {
                    timeout: 3000,
                    }
                    );
                    var patt = /current-live__item.*?img src.*?\/(.*?)\.png.*?<p>(.*?)<.*?<p>(.*?)</s
                    const result = patt.exec(res.data);
                    data.wdata = {
                        tmp: parseInt(result[2]),
                        code: parseInt(result[1].slice(-3)),
                    };
                    data.count = 0;
                    data.timer = setTimeout(
                        () => this.queryWeather(context, device),
                        1000 * 60 * 60 * 4
                    );
                    $websocket.setSettings(context, data);
                    this.canvasFunc(context, device);
                }else{
                    const key = "c4aeca457d9e4a36a9982404252804";
                    const res = await axios(
                    `http://api.weatherapi.com/v1/current.json?key=${key}&q=id:${data.cityId}&lang=${lang}`,
                    { timeout: 3000 }
                    );
                    
                    const weatherData=res.data
                    console.log(weatherData)
                    data.wdata = {
                        tmp : weatherData.current.temp_c, // 或 temp_f，根据需求
                        code : weatherData.current.condition.code, // 需要查阅 WeatherAPI.com 的 code 对应关系
                        img : 'https:' + weatherData.current.condition.icon,
                        name : weatherData.current.condition.text,
                        cityName : weatherData.location.name
                    }
                    data.count = 0;
                    data.timer = setTimeout(
                        () => this.queryWeather(context, device),
                        1000 * 60 * 60 * 4
                    );
                    $websocket.setSettings(context, data);
                    this.canvasFunc(context, device);
                }
                
            }
        } catch (e) {
            if (++data.count <= 3) {//重试3次
                this.queryWeather(context, device);
                $websocket.setTitle(context, "Try again");
                return;
            }
            // console.log(e);
            this.canvasFunc(context, device, "error");
        }
    },
    async canvasFunc(context, device, status = "success") {
        if (status === "error") {
            $websocket.setImage(
                context,
                this.data[context].isBackgroundHidden
                    ? "../static/img/tm.png"
                    : "../static/img/default.jpg"
            );
            $websocket.setTitle(context, "Timeout");
            return;
        } else if (status === "404") {
            $websocket.setImage(
                context,
                this.data[context].isBackgroundHidden
                    ? "../static/img/tm.png"
                    : "../static/img/default.jpg"
            );
            $websocket.setTitle(context, "Not found");
            return;
        }
        if (!this.data[context].cityId) return;

        // 主题配置
        const data = this.data[context];
        const { tmp, code } = data.wdata;
        // 摄氏度/华氏度
        const unit = data.tempList === "0" ? "℃" : "℉";
        const tmps = data.tempList === "0" ? tmp : tmp * 1.8 + 32;

        // 设置gif背景
        // if (data.theme == "dynamic") {
        //   $websocket.setImage(context,`${dynamicEnum[101]}`, true);
        //   $websocket.setTitle(
        //     context,
        //     data.radio == "0" ? `${Number(tmps).toFixed(1)}${unit}\n${data.city}` : `${Number(tmps).toFixed(1)}${unit}\n${data.title}`
        //   );
        //   return
        // }


        const image = new Image();
        // if (data.theme == "Modern")
        //     image.src = `../static/img/Modern/${code}-fill.svg`;
        // if (data.theme == "left")
        // if (data.theme == "Modern")
        //     image.src = `../static/img/Modern/${code}-fill.svg`;
        // if (data.theme == "left")
        if(data.apiList=="qweather"){
            image.src = `../static/img/${data.theme}/${LuxuryEnum[code]}.png`;
        }else{

            image.src = `../static/img/${data.theme}/${WeatherapiEnum[parseInt(data.wdata.img.slice(-7,-4))]}.png`;
        }

        /* 加载完毕后开始 */
        image.onload = async function () {
            let canvas = document.createElement("canvas");
            canvas.width = data.ActionGeometry.width;
            canvas.height = data.ActionGeometry.height;
            const scale = canvas.width / 512;
            let ctx = canvas.getContext("2d");

            ctx.globalAlpha = (100 - parseInt(data.opacity)) / 100;

            // if (data.theme == "Modern") ctx.drawImage(this, (canvas.width - 260) / 2, 20, 260, 260);
            ctx.drawImage(this, 0, 0, canvas.width, canvas.height);

            ctx.fillStyle = data.color ? data.color : '#ffffff';
            ctx.font = `${30 * canvas.width / 512}px 'Microsoft YaHei'`;
            ctx.textAlign = 'center';  // 设置文本对齐方式为居中
            ctx.textBaseline = 'middle';  // 设置文本基线为中心

            // 国际化json文件里面没有154，154与153是一样的夜间多云
            // ctx.fillText(data.Localization[code == 154 ? 153 : code], 392 * scale, 180 * scale);
            ctx.textAlign = 'left';  // 设置文本对齐方式
            ctx.fillText(`${data.Localization['当前']}：${Number(tmps).toFixed(1)}${unit}`, 22 * scale, 125 * scale);

            ctx.font = `${21 * scale}pt 'Microsoft YaHei'`;
            //自定义名称超出省略
            if (ctx.measureText(data.title).width > (canvas.width / 2 - (32 * scale))) {
                let flag = true;
                let text = data.title.substring(0, 7) + "...";
                while (flag) {
                    if (Math.floor(ctx.measureText(text).width) > (canvas.width / 2 - (32 * scale))) {//大于就去掉一个字符然后画上去
                        flag = false;
                        text = text = data.title.substring(0, text.length - 4) + "...";
                        ctx.fillText(data.radio == "0" ? data.city : text, 22 * scale, 76 * scale);
                    } else {
                        text = data.title.substring(0, text.length - 2) + "...";
                    }
                }
            } else {
                ctx.fillText(data.radio == "0" ? data.city : data.title, 22 * scale, 76 * scale);
            }



            // $websocket.setTitle(
            //   context,
            //   data.Localization[code == 154 ? 153 : code] + "\n" + (data.radio == "0" ? `${Number(tmps).toFixed(1)}${unit}\n${data.city}` : `${Number(tmps).toFixed(1)}${unit}\n${data.title}`)
            // );
            $websocket.setTitle(context, '');

            $websocket.setImage(context, canvas.toDataURL("image/png"));
            // console.log(canvas.toDataURL("image/png"));
        };
    },
    didReceiveSettings({ context, payload, device }) {
        this.data[context].isBackgroundHidden = payload.settings.isBackgroundHidden;
        if (payload.settings.ActionGeometry.width <= 50) {
            payload.settings.ActionGeometry.width = 50
            payload.settings.ActionGeometry.height = 20
        }
        this.data[context].ActionGeometry = payload.settings.ActionGeometry;

        this.canvasFunc(context, device);
    },
    async _willAppear({ context, device }) {

        this.data[context].Localization = await new Promise(resolve => {
            const req = new XMLHttpRequest();
            req.open('GET', `../${$lang}.json`);
            req.send();
            req.onreadystatechange = () => {
                if (req.readyState === 4) {
                    resolve(JSON.parse(req.responseText).Localization)
                }
            };
        })
        if (this.data[context].inputCity == "") {
            this.data[context].inputCity = $lang == "zh_CN" ? '北京' : "New York";
        }
        this.data[context].count = 0;
        if (this.data[context].ActionGeometry.width == undefined) {
            this.data[context].ActionGeometry.width = 123 * 1.33;
            this.data[context].ActionGeometry.height = 50 * 1.33;
        }
        this.queryLocation(context, device);
    },
    _willDisappear({ context }) {
        clearTimeout(this.data[context].timer);
    },
    sendToPlugin({ context, payload, device }) {
        const data = this.data[context];
        const { inputCity, cityId, title, theme, radio, tempList, color, opacity,apiList } = payload;
        // 输入城市
        if (inputCity !== undefined) {
            data.inputCity = inputCity;
            this.data[context].count = 0;
            return this.queryLocation(context, device);
        }
        
        // 更新天气
        if (cityId !== undefined) {
            data.cityId = cityId;
            this.data[context].count = 0;
            return this.queryWeather(context, device);
        }
        // 更新选项
        if (title !== undefined) data.title = title;
        if (theme !== undefined) data.theme = theme;
        if (radio !== undefined) data.radio = radio;
        if (color !== undefined) data.color = color;
        if (opacity !== undefined) data.opacity = opacity;
        if (tempList !== undefined) data.tempList = tempList;
        if (apiList !== undefined) {
            data.apiList = apiList;
            this.queryLocation(context, device);
            return;
        }
        this.canvasFunc(context, device);
    },
    keyUp({ context, device }) {
        this.data[context].count = 0;
        this.queryWeather(context, device);
    },
})
