const path = require('path');
const fs = require('fs-extra');

console.log('开始执行自动化构建...');

// 定义插件名和目标路径
const PluginName = 'com.hotspot.streamdock.system.monitor.text.mPanelPlugin';
const PluginPath = path.join(process.env.APPDATA, 'HotSpot/MiraBox Craft/plugins', PluginName);

try {
    // 删除旧的插件目录
    fs.removeSync(PluginPath);

    // 确保目标目录存在
    fs.ensureDirSync(path.dirname(PluginPath));

    // 复制当前目录到目标路径，排除 node_modules
    fs.copySync('./', PluginPath, {
        filter: (src) => {
            const relativePath = path.relative('./', src);
            return (
                !relativePath.startsWith('node_modules') &&
                !relativePath.includes('node_modules/') &&
                !relativePath.startsWith('.git') &&
                !relativePath.includes('.git/')
            );
        },
    });

    console.log(`插件 "${PluginName}" 已成功复制到 "${PluginPath}"`);
    console.log('构建成功-------------');
} catch (err) {
    console.error(`复制出错 "${PluginName}":`, err);
}