export function Name() {
  return 'mouse pad';
}
export function VendorId() {
  return 6700;
}
export function ProductId() {
  return 23366;
}
export function Type() {
  return 'mousePad';
}
export function Publisher() {
  return 'czy';
}
export function Fps() {
  return 24;
}
export function ControllableParameters() {
  return [
    { property: 'shutdownColor', group: 'lighting', label: 'Shutdown Color', min: '0', max: '360', type: 'color', default: '009bde' },
    { property: 'forcedColor', group: 'lighting', label: 'Forced Color', min: '0', max: '360', type: 'color', default: '009bde' }
  ];
}

var ChannelArray = [['鼠标垫', 1]];

function SetupChannels() {
  device.SetLedLimit(1);
  for (let i = 0; i < ChannelArray.length; i++) {
    device.addChannel(ChannelArray[i][0], ChannelArray[i][1],'id_'+i);
  }
}

export function Initialize() {
  SetupChannels();
}

function sendColors(name) {
  let shutdown = false;
  var color;

  if (shutdown) {
    color = hexToRgb(shutdownColor);
  } else {
    color = device.channel(name).getColors('Inline', 'RGB');
  }

  return color;
  //64为字节数
  // console.log(packet);
  //   device.write(Uint8Array.from(packet),64);
}

export function Render() {
  let packet = [0xf7, 0x00, 0x05, 0xf4];
  for (let i = 0; i < ChannelArray.length; i++) {
    device.channel(ChannelArray[i][0]).LedLimit(ChannelArray[i][1]);
    packet = packet.concat(sendColors(ChannelArray[i][0]).reverse());
  }
  packet = packet.flat();
  device.write(packet, 7, 0x07);
}

export function Shutdown() {
  let packet = [0x07, 0xf7, 0x05, 0x05, 0xf4, 0xff, 0xff, 0xff];
  device.write(packet, 8);
}

function hexToRgb(hex) {
  let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
  let colors = [];
  colors[0] = parseInt(result[1], 16);
  colors[1] = parseInt(result[2], 16);
  colors[2] = parseInt(result[3], 16);

  return colors;
}

export function Validate() {
  return { type: 0, usage: 0x0001, usagePage: 0x000c };
}

export function Image() {
  return '';
}
