export function Name() { return "SLE-USB"; }
export function VendorId() { return 4369; }
export function ProductId() { return 18; }
export function Type() { return 'SLE-USB'; }
export function Publisher() { return "czy"; }
export function Fps() { return 35; }
const USB_DELAY = 0;
export function ControllableParameters() {
	return [
		{ "property": "shutdownColor", "group": "lighting", "label": "Shutdown Color", "min": "0", "max": "360", "type": "color", "default": "009bde" },
		{ "property": "forcedColor", "group": "lighting", "label": "Forced Color", "min": "0", "max": "360", "type": "color", "default": "009bde" },
	];
}

var ChannelArray = [
	// ["风扇0", 24,0]
  // ,["风扇1", 24],["风扇2", 24]
]
var idConversion = [] // 用于存储蓝牙连接分配id
function generateId() {
  // 使用随机数来生成ID，确保其唯一性
  return 'id-' + Math.random().toString(36).substr(2, 9);
}
function sleep(ms) {
  return new Promise(resolve => setTimeout(resolve, ms));
}
function SetupChannels() {

  //   for (let i = 0; i < ChannelArray.length; i++) {
  //     device.addChannel(ChannelArray[i][0], ChannelArray[i][1]);
  //   }
  }
  
  export function Initialize() {
    // SetupChannels();
  }
  // 初始化有多少个灯数据
  export function dateLength() {
    return ChannelArray.map((item, index)=>{
      return {
        id:item.onlyId,
        name:item.typeName,
      }
    })
    // return ChannelArray.length
  }
  // 当设备拔出，清空已连接设备
  export function onClearDevice() {
    ChannelArray = []
  }

// 连接设备
/*   export function onmodify(ov) { */
  export function onLinkingDevice(date) {
   
      // ChannelArray = ov
      // device.clearChannel()
      // SetupChannels();
      // device.updateChannelNum()
      // ChannelArray.forEach((item,index)=>{
      //   if(item[3] && device.areArraysEqual(item[3],ov)){
      //     deleteIndex = index
      //     device.removeChannel(item[0],item[2])
      //   }
      // })
      let exist = ChannelArray.some((item, index)=>{
        // return device.areArraysEqual(item[3],date.onlyId)
        return item.onlyId == date.onlyId
      })
      // console.log('ChannelArray4444444',date,exist)
      // 当不存在的时候再往里追加，有的时候连接一个设备，会发俩次消息
      if(!exist){
        ChannelArray.push(date)
        device.addChannel(date.typeName,date.led,date.onlyId,);
        device.addSubLamp(date.typeName,date.led,date.onlyId,);
        device.updateChannelNum(ChannelArray,dateLength())
        // let subchannel = device.subchannel()
        // console.log('ChannelArray3333333',ChannelArray)

      }else{
        ChannelArray.forEach((item, index)=>{
         if(item.onlyId == date.onlyId && date.passId != item.passId ){
          item.passId = date.passId
          ChannelArray[index].passId = date.passId
         }
        })
      }

      // console.log('连接1111111111--------nzw111111',date,JSON.parse(JSON.stringify(ChannelArray)))


  }

  // 断开连接
  export function onBreakDevice(ov) {
    let deleteIndex = -1
    // console.log('断开连接1111111111--------nzw111111',ov,ChannelArray)
    ChannelArray.forEach((item,index)=>{
      // if(item[3] && device.areArraysEqual(item[3],ov)){
      if(item.onlyId && item.onlyId == ov){
        deleteIndex = index
        device.removeChannel(item.typeName,item.onlyId)
      }
    })
    if(deleteIndex >-1){
    //  需要删除
     device.updateChannelNum(ChannelArray,dateLength())
     ChannelArray.splice(deleteIndex, 1)
    }
    // console.log('断开连接ChannelArray55555',ChannelArray)
  }

  
  function sendColors(name,id=undefined) {
    let shutdown = false;
    var color;
  
    if (shutdown) {
      color = hexToRgb(shutdownColor);
    } else {
      // color = device.channel(name).getColors('Inline', 'RGB');
      color = device.channel(name,id).getColors('Inline', 'GRB');
    }
  
    return color;
    //64为字节数
    // console.log(packet);
    //   device.write(Uint8Array.from(packet),64);
  }

// // 在 forEach 循环中使用 await
  // const forEachLoop = _ => {
  //   console.log('Start');
  
  //   fruitsToGet.forEach(async fruit => {
  //     const numFruit = await getNumFruit(fruit);
  //     console.log(numFruit)
  //   });
  
  //   console.log('End')
  // }
// //在 for 循环中使用 await
  // const forLoop = async _ => {
  //   console.log('start');
  
  //   for (let index = 0; index < fruitsToGet.length; index ++) {
  //     const fruit = fruitsToGet[index];
  //     const numFruit = await getNumFruit(fruit);
  //     console.log(numFruit);
  //   }
  //   console.log('End')
  // }

  // const getNumFruit = fruit => {
  //   return 1
  // }



//     const asyncFunctions = [...Array(10).keys()].map(i => () => {
//   // 这里创建一个返回promise的异步函数
//   return new Promise((resolve, reject) => {
//     setTimeout(() => {
//       console.log(`Function ${i} executed`);
//       resolve();
//     }, 6000);
//   });
// });
 
// // 使用reduce来顺序执行这些异步函数
// asyncFunctions.reduce((promiseChain, currentFunction) => {
//   return promiseChain.then(currentFunction).catch(error => console.error(error));
// }, Promise.resolve());







  
  export async function Render() {
    // let packet = [];
    // packet[0] = 65;
    // // packet.push(0);
  
    // // for (let o = 0; o < ChannelArray.length; o++) {
    // packet[1] = ChannelArray[0][1];
    // // packet[2] = 0;
    // // }
    // console.log('Render--------nzw00000',ChannelArray)
    for (let i = 0; i < ChannelArray.length; i++) {

      let packet = [];
      packet[0] = 65;
      packet[1] = ChannelArray[i].led;
      packet[2] = ChannelArray[i].passId;

      device.channel(ChannelArray[i].typeName).LedLimit(ChannelArray[i].led);
      let dataNew = sendColors(ChannelArray[i].typeName,ChannelArray[i].onlyId).reverse()
      packet = packet.concat(dataNew)
      // console.log('packet---1111',dataNew,ChannelArray[i].onlyId)
      packet.push(0x01);
      packet = packet.flat();

      if(dataNew && dataNew.length>0){
          // console.log('packet---3333',packet)
        await device.write(packet);

      }
      await sleep(USB_DELAY);
      // for (let i = 0; i < packet.length; i += 64) {
      //   const data = packet.slice(i, i + 64);
      //   device.write(data, 64);
      // }
    }
  }
  
  export function Shutdown() {
    let packet = [];
    packet[0] = 65;
    packet[1] = ChannelArray[0][1];
    packet[2] = 0;
    for (let i = 0; i < ChannelArray.length * ChannelArray[i][1]; i++) {
      packet.push(255, 255, 255);
    }
    packet.push(0x01);
    packet = packet.flat();
    // packet = packet.flat(1);
    for (let i = 0; i < packet.length; i += 64) {
      const data = packet.slice(i, i + 64);
    //   device.write(data, 64);
    }
  }
  
  function hexToRgb(hex) {
    let result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
    let colors = [];
    colors[0] = parseInt(result[1], 16);
    colors[1] = parseInt(result[2], 16);
    colors[2] = parseInt(result[3], 16);
  
    return colors;
  }
  
  export function Validate() {
    return { type: 0, usage: 0x0001, usagePage: 0xFF0A };
  }
  
  export function Image() {
    return '';
  }
  